/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.error_messages;

import com.itextpdf.text.pdf.BaseFont;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageLocalization {
    private static HashMap<String, String> defaultLanguage = new HashMap();
    private static HashMap<String, String> currentLanguage;
    private static final String BASE_PATH = "com/itextpdf/text/l10n/error/";

    private MessageLocalization() {
    }

    public static String getMessage(String key) {
        String val;
        HashMap<String, String> cl = currentLanguage;
        if (cl != null && (val = cl.get(key)) != null) {
            return val;
        }
        cl = defaultLanguage;
        val = cl.get(key);
        if (val != null) {
            return val;
        }
        return "No message found for " + key;
    }

    public static String getComposedMessage(String key, int p1) {
        return MessageLocalization.getComposedMessage(key, String.valueOf(p1), null, null, null);
    }

    public static String getComposedMessage(String key, Object ... param) {
        String msg = MessageLocalization.getMessage(key);
        if (null != param) {
            int i = 1;
            for (Object o : param) {
                if (null != o) {
                    msg = msg.replace("{" + i + "}", o.toString());
                }
                ++i;
            }
        }
        return msg;
    }

    public static boolean setLanguage(String language, String country) throws IOException {
        HashMap<String, String> lang = MessageLocalization.getLanguageMessages(language, country);
        if (lang == null) {
            return false;
        }
        currentLanguage = lang;
        return true;
    }

    public static void setMessages(Reader r) throws IOException {
        currentLanguage = MessageLocalization.readLanguageStream(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap<String, String> getLanguageMessages(String language, String country) throws IOException {
        if (language == null) {
            throw new IllegalArgumentException("The language cannot be null.");
        }
        InputStream is = null;
        try {
            String file = country != null ? language + "_" + country + ".lng" : language + ".lng";
            is = BaseFont.getResourceStream(BASE_PATH + file, new MessageLocalization().getClass().getClassLoader());
            if (is != null) {
                HashMap<String, String> hashMap = MessageLocalization.readLanguageStream(is);
                return hashMap;
            }
            if (country == null) {
                HashMap<String, String> hashMap = null;
                return hashMap;
            }
            file = language + ".lng";
            is = BaseFont.getResourceStream(BASE_PATH + file, new MessageLocalization().getClass().getClassLoader());
            if (is != null) {
                HashMap<String, String> hashMap = MessageLocalization.readLanguageStream(is);
                return hashMap;
            }
            HashMap<String, String> hashMap = null;
            return hashMap;
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static HashMap<String, String> readLanguageStream(InputStream is) throws IOException {
        return MessageLocalization.readLanguageStream(new InputStreamReader(is, "UTF-8"));
    }

    private static HashMap<String, String> readLanguageStream(Reader r) throws IOException {
        String line;
        HashMap<String, String> lang = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(r);
        while ((line = br.readLine()) != null) {
            String key;
            int idxeq = line.indexOf(61);
            if (idxeq < 0 || (key = line.substring(0, idxeq).trim()).startsWith("#")) continue;
            lang.put(key, line.substring(idxeq + 1));
        }
        return lang;
    }

    static {
        try {
            defaultLanguage = MessageLocalization.getLanguageMessages("en", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultLanguage == null) {
            defaultLanguage = new HashMap();
        }
    }
}

