/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.OcspClient;
import com.itextpdf.text.pdf.PdfEncryption;
import com.itextpdf.text.pdf.PdfPKCS7;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Vector;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.ocsp.BasicOCSPResp;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.CertificateStatus;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPReq;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.ocsp.RevokedStatus;
import kz.gov.pki.kalkan.ocsp.SingleResp;

public class OcspClientBouncyCastle
implements OcspClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcspClientBouncyCastle.class);

    private static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException, IOException {
        Security.addProvider(new KalkanProvider());
        CertificateID id = new CertificateID(CertificateID.HASH_SHA1, issuerCert, serialNumber);
        OCSPReqGenerator gen = new OCSPReqGenerator();
        gen.addRequest(id);
        Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        oids.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(new DEROctetString(PdfEncryption.createDocumentId()).getEncoded())));
        gen.setRequestExtensions(new X509Extensions(oids, values));
        return gen.generate();
    }

    public byte[] getEncoded(X509Certificate checkCert, X509Certificate rootCert, String url) {
        block10: {
            try {
                SingleResp[] responses;
                if (checkCert == null || rootCert == null) {
                    return null;
                }
                if (url == null) {
                    url = PdfPKCS7.getOCSPURL(checkCert);
                }
                if (url == null) {
                    return null;
                }
                OCSPReq request = OcspClientBouncyCastle.generateOCSPRequest(rootCert, checkCert.getSerialNumber());
                byte[] array = request.getEncoded();
                URL urlt = new URL(url);
                HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
                con.setRequestProperty("Content-Type", "application/ocsp-request");
                con.setRequestProperty("Accept", "application/ocsp-response");
                con.setDoOutput(true);
                OutputStream out = con.getOutputStream();
                DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
                dataOut.write(array);
                dataOut.flush();
                dataOut.close();
                if (con.getResponseCode() / 100 != 2) {
                    throw new IOException(MessageLocalization.getComposedMessage("invalid.http.response.1", con.getResponseCode()));
                }
                InputStream in = (InputStream)con.getContent();
                OCSPResp ocspResponse = new OCSPResp(in);
                if (ocspResponse.getStatus() != 0) {
                    throw new IOException(MessageLocalization.getComposedMessage("invalid.status.1", ocspResponse.getStatus()));
                }
                BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
                if (basicResponse != null && (responses = basicResponse.getResponses()).length == 1) {
                    SingleResp resp = responses[0];
                    Object status = resp.getCertStatus();
                    if (status == CertificateStatus.GOOD) {
                        return basicResponse.getEncoded();
                    }
                    if (status instanceof RevokedStatus) {
                        throw new IOException(MessageLocalization.getComposedMessage("ocsp.status.is.revoked", new Object[0]));
                    }
                    throw new IOException(MessageLocalization.getComposedMessage("ocsp.status.is.unknown", new Object[0]));
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isLogging(Level.ERROR)) break block10;
                LOGGER.error("OcspClientBouncyCastle", ex);
            }
        }
        return null;
    }
}

