/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.crypto;

import kz.gov.pki.kalkan.crypto.engines.AESFastEngine;
import kz.gov.pki.kalkan.crypto.modes.CBCBlockCipher;
import kz.gov.pki.kalkan.crypto.paddings.PaddedBufferedBlockCipher;
import kz.gov.pki.kalkan.crypto.params.KeyParameter;
import kz.gov.pki.kalkan.crypto.params.ParametersWithIV;

public class AESCipher {
    private PaddedBufferedBlockCipher bp;

    public AESCipher(boolean forEncryption, byte[] key, byte[] iv) {
        AESFastEngine aes = new AESFastEngine();
        CBCBlockCipher cbc = new CBCBlockCipher(aes);
        this.bp = new PaddedBufferedBlockCipher(cbc);
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV piv = new ParametersWithIV(kp, iv);
        this.bp.init(forEncryption, piv);
    }

    public byte[] update(byte[] inp, int inpOff, int inpLen) {
        int neededLen = this.bp.getUpdateOutputSize(inpLen);
        byte[] outp = null;
        if (neededLen > 0) {
            outp = new byte[neededLen];
        } else {
            neededLen = 0;
        }
        this.bp.processBytes(inp, inpOff, inpLen, outp, 0);
        return outp;
    }

    public byte[] doFinal() {
        int neededLen = this.bp.getOutputSize(0);
        byte[] outp = new byte[neededLen];
        int n = 0;
        try {
            n = this.bp.doFinal(outp, 0);
        }
        catch (Exception ex) {
            return outp;
        }
        if (n != outp.length) {
            byte[] outp2 = new byte[n];
            System.arraycopy(outp, 0, outp2, 0, n);
            return outp2;
        }
        return outp;
    }
}

