/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1.cmp;

import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1TaggedObject;
import kz.gov.pki.kalkan.asn1.DERBitString;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;
import kz.gov.pki.kalkan.asn1.crmf.CertId;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;

public class OOBCertHash
extends ASN1Encodable {
    private AlgorithmIdentifier hashAlg;
    private CertId certId;
    private DERBitString hashVal;

    private OOBCertHash(ASN1Sequence seq) {
        int index = seq.size() - 1;
        this.hashVal = DERBitString.getInstance(seq.getObjectAt(index--));
        for (int i = index; i >= 0; --i) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)seq.getObjectAt(i);
            if (tObj.getTagNo() == 0) {
                this.hashAlg = AlgorithmIdentifier.getInstance(tObj, true);
                continue;
            }
            this.certId = CertId.getInstance(tObj, true);
        }
    }

    public static OOBCertHash getInstance(Object o) {
        if (o instanceof OOBCertHash) {
            return (OOBCertHash)o;
        }
        if (o instanceof ASN1Sequence) {
            return new OOBCertHash((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public CertId getCertId() {
        return this.certId;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        this.addOptional(v, 0, this.hashAlg);
        this.addOptional(v, 1, this.certId);
        v.add(this.hashVal);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

