/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1.ocsp;

import kz.gov.pki.kalkan.asn1.ASN1Choice;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1TaggedObject;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;
import kz.gov.pki.kalkan.asn1.x509.X509Name;

public class ResponderID
extends ASN1Encodable
implements ASN1Choice {
    private DEREncodable value;

    public ResponderID(ASN1OctetString value) {
        this.value = value;
    }

    public ResponderID(X509Name value) {
        this.value = value;
    }

    public static ResponderID getInstance(Object obj) {
        if (obj == null || obj instanceof ResponderID) {
            return (ResponderID)obj;
        }
        if (obj instanceof DEROctetString) {
            return new ResponderID((DEROctetString)obj);
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject o = (ASN1TaggedObject)obj;
            if (o.getTagNo() == 1) {
                return new ResponderID(X509Name.getInstance(o, true));
            }
            return new ResponderID(ASN1OctetString.getInstance(o, true));
        }
        return new ResponderID(X509Name.getInstance(obj));
    }

    public static ResponderID getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ResponderID.getInstance(obj.getObject());
    }

    public DERObject toASN1Object() {
        if (this.value instanceof ASN1OctetString) {
            return new DERTaggedObject(true, 2, this.value);
        }
        return new DERTaggedObject(true, 1, this.value);
    }
}

