/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1.x500;

import kz.gov.pki.kalkan.asn1.ASN1Choice;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1TaggedObject;
import kz.gov.pki.kalkan.asn1.DERBMPString;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERPrintableString;
import kz.gov.pki.kalkan.asn1.DERString;
import kz.gov.pki.kalkan.asn1.DERT61String;
import kz.gov.pki.kalkan.asn1.DERUTF8String;
import kz.gov.pki.kalkan.asn1.DERUniversalString;

public class DirectoryString
extends ASN1Encodable
implements ASN1Choice,
DERString {
    private DERString string;

    public static DirectoryString getInstance(Object o) {
        if (o instanceof DirectoryString) {
            return (DirectoryString)o;
        }
        if (o instanceof DERT61String) {
            return new DirectoryString((DERT61String)o);
        }
        if (o instanceof DERPrintableString) {
            return new DirectoryString((DERPrintableString)o);
        }
        if (o instanceof DERUniversalString) {
            return new DirectoryString((DERUniversalString)o);
        }
        if (o instanceof DERUTF8String) {
            return new DirectoryString((DERUTF8String)o);
        }
        if (o instanceof DERBMPString) {
            return new DirectoryString((DERBMPString)o);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + o.getClass().getName());
    }

    public static DirectoryString getInstance(ASN1TaggedObject o, boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("choice item must be explicitly tagged");
        }
        return DirectoryString.getInstance(o.getObject());
    }

    private DirectoryString(DERT61String string) {
        this.string = string;
    }

    private DirectoryString(DERPrintableString string) {
        this.string = string;
    }

    private DirectoryString(DERUniversalString string) {
        this.string = string;
    }

    private DirectoryString(DERUTF8String string) {
        this.string = string;
    }

    private DirectoryString(DERBMPString string) {
        this.string = string;
    }

    public DirectoryString(String string) {
        this.string = new DERUTF8String(string);
    }

    public String getString() {
        return this.string.getString();
    }

    public String toString() {
        return this.string.getString();
    }

    public DERObject toASN1Object() {
        return ((DEREncodable)((Object)this.string)).getDERObject();
    }
}

