/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1.x509;

import java.io.IOException;
import kz.gov.pki.kalkan.asn1.DERGeneralizedTime;
import kz.gov.pki.kalkan.asn1.DERIA5String;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERPrintableString;
import kz.gov.pki.kalkan.asn1.DERUTF8String;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.asn1.x509.X509NameEntryConverter;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    public DERObject getConvertedValue(DERObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(value, 1);
            }
            catch (IOException e) {
                throw new RuntimeException("can't recode value for oid " + oid.getId());
            }
        }
        if (value.length() != 0 && value.charAt(0) == '\\') {
            value = value.substring(1);
        }
        if (oid.equals(X509Name.EmailAddress) || oid.equals(X509Name.DC)) {
            return new DERIA5String(value);
        }
        if (oid.equals(X509Name.DATE_OF_BIRTH)) {
            return new DERGeneralizedTime(value);
        }
        if (oid.equals(X509Name.C) || oid.equals(X509Name.SN) || oid.equals(X509Name.DN_QUALIFIER) || oid.equals(X509Name.TELEPHONE_NUMBER)) {
            return new DERPrintableString(value);
        }
        return new DERUTF8String(value);
    }
}

