/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.crypto.digests;

import java.io.IOException;
import java.util.Vector;
import kz.gov.pki.kalkan.crypto.ExtendedDigest;
import kz.gov.pki.kalkan.util.Arrays;

public class KalkanSha1Digest
implements ExtendedDigest {
    private static final int DIGEST_LENGTH = 20;
    private Vector<Byte> digestData = new Vector();

    private native int GetHashSha1(byte[] var1, int var2, byte[] var3, int[] var4);

    public KalkanSha1Digest() {
    }

    public KalkanSha1Digest(KalkanSha1Digest t) {
        this.reset();
        this.digestData = (Vector)t.digestData.clone();
    }

    public String getAlgorithmName() {
        return "SHA-1";
    }

    public int getDigestSize() {
        return 20;
    }

    public void update(byte in) {
        this.digestData.add(in);
    }

    public void update(byte[] in, int inOff, int len) {
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] digestResult = this.finish();
        if (digestResult == null) {
            return -1;
        }
        System.arraycopy(digestResult, 0, out, outOff, digestResult.length);
        this.reset();
        return digestResult.length;
    }

    public void reset() {
        this.digestData.clear();
    }

    public int getByteLength() {
        return 32;
    }

    private byte[] finish() {
        int[] hashSize = new int[16];
        hashSize[0] = 80;
        byte[] hash = new byte[hashSize[0]];
        byte[] data = null;
        try {
            data = Arrays.ByteVectorToArray(this.digestData);
        }
        catch (IOException e) {
            e.toString();
            return null;
        }
        if (this.GetHashSha1(data, data.length, hash, hashSize) != 0) {
            return null;
        }
        byte[] result = new byte[hashSize[0]];
        System.arraycopy(hash, 0, result, 0, hashSize[0]);
        return result;
    }
}

