/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.crypto.modes;

import kz.gov.pki.kalkan.crypto.BlockCipher;
import kz.gov.pki.kalkan.crypto.CipherParameters;
import kz.gov.pki.kalkan.crypto.DataLengthException;
import kz.gov.pki.kalkan.crypto.InvalidCipherTextException;
import kz.gov.pki.kalkan.crypto.modes.AEADBlockCipher;
import kz.gov.pki.kalkan.crypto.modes.gcm.GCMMultiplier;
import kz.gov.pki.kalkan.crypto.modes.gcm.Tables8kGCMMultiplier;
import kz.gov.pki.kalkan.crypto.params.AEADParameters;
import kz.gov.pki.kalkan.crypto.params.KeyParameter;
import kz.gov.pki.kalkan.crypto.params.ParametersWithIV;
import kz.gov.pki.kalkan.crypto.util.Pack;
import kz.gov.pki.kalkan.util.Arrays;

public class GCMBlockCipher
implements AEADBlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final byte[] ZEROES = new byte[16];
    private BlockCipher cipher;
    private GCMMultiplier multiplier;
    private boolean forEncryption;
    private int macSize;
    private byte[] nonce;
    private byte[] A;
    private KeyParameter keyParam;
    private byte[] H;
    private byte[] initS;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private byte[] S;
    private byte[] counter;
    private int bufOff;
    private long totalLength;

    public GCMBlockCipher(BlockCipher c) {
        this(c, null);
    }

    public GCMBlockCipher(BlockCipher c, GCMMultiplier m) {
        if (c.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        if (m == null) {
            m = new Tables8kGCMMultiplier();
        }
        this.cipher = c;
        this.multiplier = m;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCM";
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        CipherParameters param;
        this.forEncryption = forEncryption;
        this.macBlock = null;
        if (params instanceof AEADParameters) {
            param = (AEADParameters)params;
            this.nonce = ((AEADParameters)param).getNonce();
            this.A = ((AEADParameters)param).getAssociatedText();
            int macSizeBits = ((AEADParameters)param).getMacSize();
            if (macSizeBits < 96 || macSizeBits > 128 || macSizeBits % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
            }
            this.macSize = macSizeBits / 8;
            this.keyParam = ((AEADParameters)param).getKey();
        } else if (params instanceof ParametersWithIV) {
            param = (ParametersWithIV)params;
            this.nonce = ((ParametersWithIV)param).getIV();
            this.A = null;
            this.macSize = 16;
            this.keyParam = (KeyParameter)((ParametersWithIV)param).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        int bufLength = forEncryption ? 16 : 16 + this.macSize;
        this.bufBlock = new byte[bufLength];
        if (this.nonce == null || this.nonce.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (this.A == null) {
            this.A = new byte[0];
        }
        this.cipher.init(true, this.keyParam);
        this.H = new byte[16];
        this.cipher.processBlock(ZEROES, 0, this.H, 0);
        this.multiplier.init(this.H);
        this.initS = this.gHASH(this.A);
        if (this.nonce.length == 12) {
            this.J0 = new byte[16];
            System.arraycopy(this.nonce, 0, this.J0, 0, this.nonce.length);
            this.J0[15] = 1;
        } else {
            this.J0 = this.gHASH(this.nonce);
            byte[] X = new byte[16];
            GCMBlockCipher.packLength((long)this.nonce.length * 8L, X, 8);
            GCMBlockCipher.xor(this.J0, X);
            this.multiplier.multiplyH(this.J0);
        }
        this.S = Arrays.clone(this.initS);
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
    }

    public byte[] getMac() {
        return Arrays.clone(this.macBlock);
    }

    public int getOutputSize(int len) {
        if (this.forEncryption) {
            return len + this.bufOff + this.macSize;
        }
        return len + this.bufOff - this.macSize;
    }

    public int getUpdateOutputSize(int len) {
        return (len + this.bufOff) / 16 * 16;
    }

    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.process(in, out, outOff);
    }

    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        int resultLen = 0;
        for (int i = 0; i != len; ++i) {
            this.bufBlock[this.bufOff++] = in[inOff + i];
            if (this.bufOff != this.bufBlock.length) continue;
            this.gCTRBlock(this.bufBlock, 16, out, outOff + resultLen);
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, this.macSize);
            }
            this.bufOff = this.bufBlock.length - 16;
            resultLen += 16;
        }
        return resultLen;
    }

    private int process(byte in, byte[] out, int outOff) throws DataLengthException {
        this.bufBlock[this.bufOff++] = in;
        if (this.bufOff == this.bufBlock.length) {
            this.gCTRBlock(this.bufBlock, 16, out, outOff);
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, this.macSize);
            }
            this.bufOff = this.bufBlock.length - 16;
            return 16;
        }
        return 0;
    }

    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int extra = this.bufOff;
        if (!this.forEncryption) {
            if (extra < this.macSize) {
                throw new InvalidCipherTextException("data too short");
            }
            extra -= this.macSize;
        }
        if (extra > 0) {
            byte[] tmp = new byte[16];
            System.arraycopy(this.bufBlock, 0, tmp, 0, extra);
            this.gCTRBlock(tmp, extra, out, outOff);
        }
        byte[] X = new byte[16];
        GCMBlockCipher.packLength((long)this.A.length * 8L, X, 0);
        GCMBlockCipher.packLength(this.totalLength * 8L, X, 8);
        GCMBlockCipher.xor(this.S, X);
        this.multiplier.multiplyH(this.S);
        byte[] tag = new byte[16];
        this.cipher.processBlock(this.J0, 0, tag, 0);
        GCMBlockCipher.xor(tag, this.S);
        int resultLen = extra;
        this.macBlock = new byte[this.macSize];
        System.arraycopy(tag, 0, this.macBlock, 0, this.macSize);
        if (this.forEncryption) {
            System.arraycopy(this.macBlock, 0, out, outOff + this.bufOff, this.macSize);
            resultLen += this.macSize;
        } else {
            byte[] msgMac = new byte[this.macSize];
            System.arraycopy(this.bufBlock, extra, msgMac, 0, this.macSize);
            if (!Arrays.constantTimeAreEqual(this.macBlock, msgMac)) {
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
        }
        this.reset(false);
        return resultLen;
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean clearMac) {
        this.S = Arrays.clone(this.initS);
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.bufBlock != null) {
            Arrays.fill(this.bufBlock, (byte)0);
        }
        if (clearMac) {
            this.macBlock = null;
        }
        this.cipher.reset();
    }

    private void gCTRBlock(byte[] buf, int bufCount, byte[] out, int outOff) {
        byte[] hashBytes;
        for (int i = 15; i >= 12; --i) {
            byte b;
            this.counter[i] = b = (byte)(this.counter[i] + 1 & 0xFF);
            if (b != 0) break;
        }
        byte[] tmp = new byte[16];
        this.cipher.processBlock(this.counter, 0, tmp, 0);
        if (this.forEncryption) {
            System.arraycopy(ZEROES, bufCount, tmp, bufCount, 16 - bufCount);
            hashBytes = tmp;
        } else {
            hashBytes = buf;
        }
        for (int i = bufCount - 1; i >= 0; --i) {
            int n = i;
            tmp[n] = (byte)(tmp[n] ^ buf[i]);
            out[outOff + i] = tmp[i];
        }
        GCMBlockCipher.xor(this.S, hashBytes);
        this.multiplier.multiplyH(this.S);
        this.totalLength += (long)bufCount;
    }

    private byte[] gHASH(byte[] b) {
        byte[] Y = new byte[16];
        for (int pos = 0; pos < b.length; pos += 16) {
            byte[] X = new byte[16];
            int num = Math.min(b.length - pos, 16);
            System.arraycopy(b, pos, X, 0, num);
            GCMBlockCipher.xor(Y, X);
            this.multiplier.multiplyH(Y);
        }
        return Y;
    }

    private static void xor(byte[] block, byte[] val) {
        for (int i = 15; i >= 0; --i) {
            int n = i;
            block[n] = (byte)(block[n] ^ val[i]);
        }
    }

    private static void packLength(long count, byte[] bs, int off) {
        Pack.intToBigEndian((int)(count >>> 32), bs, off);
        Pack.intToBigEndian((int)count, bs, off + 4);
    }
}

