/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.crypto.signers;

import kz.gov.pki.kalkan.crypto.AsymmetricBlockCipher;
import kz.gov.pki.kalkan.crypto.CipherParameters;
import kz.gov.pki.kalkan.crypto.CryptoException;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.SignerWithRecovery;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.crypto.params.RSAKeyParameters;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;

    public ISO9796d2Signer(AsymmetricBlockCipher cipher, Digest digest, boolean implicit) {
        this.cipher = cipher;
        this.digest = digest;
        if (implicit) {
            this.trailer = 188;
        } else if (digest instanceof SHA1Digest) {
            this.trailer = 13260;
        } else {
            throw new IllegalArgumentException("no valid trailer for digest");
        }
    }

    public ISO9796d2Signer(AsymmetricBlockCipher cipher, Digest digest) {
        this(cipher, digest, false);
    }

    public void init(boolean forSigning, CipherParameters param) {
        RSAKeyParameters kParam = (RSAKeyParameters)param;
        this.cipher.init(forSigning, kParam);
        this.keyBits = kParam.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.mBuf = this.trailer == 188 ? new byte[this.block.length - this.digest.getDigestSize() - 2] : new byte[this.block.length - this.digest.getDigestSize() - 3];
        this.reset();
    }

    private boolean isSameAs(byte[] a, byte[] b) {
        if (this.messageLength > this.mBuf.length) {
            if (this.mBuf.length > b.length) {
                return false;
            }
            for (int i = 0; i != this.mBuf.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
        } else {
            if (this.messageLength != b.length) {
                return false;
            }
            for (int i = 0; i != b.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
        }
        return true;
    }

    private void clearBlock(byte[] block) {
        for (int i = 0; i != block.length; ++i) {
            block[i] = 0;
        }
    }

    public void update(byte b) {
        this.digest.update(b);
        if (this.messageLength < this.mBuf.length) {
            this.mBuf[this.messageLength] = b;
        }
        ++this.messageLength;
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
        if (this.messageLength < this.mBuf.length) {
            for (int i = 0; i < len && i + this.messageLength < this.mBuf.length; ++i) {
                this.mBuf[this.messageLength + i] = in[off + i];
            }
        }
        this.messageLength += len;
    }

    public void reset() {
        this.digest.reset();
        this.messageLength = 0;
        this.clearBlock(this.mBuf);
        if (this.recoveredMessage != null) {
            this.clearBlock(this.recoveredMessage);
        }
        this.recoveredMessage = null;
        this.fullMessage = false;
    }

    public byte[] generateSignature() throws CryptoException {
        int digSize = this.digest.getDigestSize();
        int t = 0;
        int delta = 0;
        if (this.trailer == 188) {
            t = 8;
            delta = this.block.length - digSize - 1;
            this.digest.doFinal(this.block, delta);
            this.block[this.block.length - 1] = -68;
        } else {
            t = 16;
            delta = this.block.length - digSize - 2;
            this.digest.doFinal(this.block, delta);
            this.block[this.block.length - 2] = (byte)(this.trailer >>> 8);
            this.block[this.block.length - 1] = (byte)this.trailer;
        }
        int header = 0;
        int x = (digSize + this.messageLength) * 8 + t + 4 - this.keyBits;
        if (x > 0) {
            int mR = this.messageLength - (x + 7) / 8;
            header = 96;
            System.arraycopy(this.mBuf, 0, this.block, delta -= mR, mR);
        } else {
            header = 64;
            System.arraycopy(this.mBuf, 0, this.block, delta -= this.messageLength, this.messageLength);
        }
        if (delta - 1 > 0) {
            for (int i = delta - 1; i != 0; --i) {
                this.block[i] = -69;
            }
            int n = delta - 1;
            this.block[n] = (byte)(this.block[n] ^ 1);
            this.block[0] = 11;
            this.block[0] = (byte)(this.block[0] | header);
        } else {
            this.block[0] = 10;
            this.block[0] = (byte)(this.block[0] | header);
        }
        byte[] b = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.mBuf);
        this.clearBlock(this.block);
        return b;
    }

    public boolean verifySignature(byte[] signature) {
        byte[] block = null;
        try {
            block = this.cipher.processBlock(signature, 0, signature.length);
        }
        catch (Exception e) {
            return false;
        }
        if ((block[0] & 0xC0 ^ 0x40) != 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(block);
            return false;
        }
        if ((block[block.length - 1] & 0xF ^ 0xC) != 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(block);
            return false;
        }
        int delta = 0;
        if ((block[block.length - 1] & 0xFF ^ 0xBC) == 0) {
            delta = 1;
        } else {
            int sigTrail = (block[block.length - 2] & 0xFF) << 8 | block[block.length - 1] & 0xFF;
            switch (sigTrail) {
                case 13260: {
                    if (this.digest instanceof SHA1Digest) break;
                    throw new IllegalStateException("signer should be initialised with SHA1");
                }
                default: {
                    throw new IllegalArgumentException("unrecognised hash in signature");
                }
            }
            delta = 2;
        }
        int mStart = 0;
        for (mStart = 0; mStart != block.length && (block[mStart] & 0xF ^ 0xA) != 0; ++mStart) {
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        int off = block.length - delta - hash.length;
        if (off - ++mStart <= 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(block);
            return false;
        }
        if ((block[0] & 0x20) == 0) {
            this.fullMessage = true;
            this.digest.reset();
            this.digest.update(block, mStart, off - mStart);
            this.digest.doFinal(hash, 0);
            for (int i = 0; i != hash.length; ++i) {
                int n = off + i;
                block[n] = (byte)(block[n] ^ hash[i]);
                if (block[off + i] == 0) continue;
                this.clearBlock(this.mBuf);
                this.clearBlock(block);
                return false;
            }
            this.recoveredMessage = new byte[off - mStart];
            System.arraycopy(block, mStart, this.recoveredMessage, 0, this.recoveredMessage.length);
        } else {
            this.fullMessage = false;
            this.digest.doFinal(hash, 0);
            for (int i = 0; i != hash.length; ++i) {
                int n = off + i;
                block[n] = (byte)(block[n] ^ hash[i]);
                if (block[off + i] == 0) continue;
                this.clearBlock(this.mBuf);
                this.clearBlock(block);
                return false;
            }
            this.recoveredMessage = new byte[off - mStart];
            System.arraycopy(block, mStart, this.recoveredMessage, 0, this.recoveredMessage.length);
        }
        if (this.messageLength != 0 && !this.isSameAs(this.mBuf, this.recoveredMessage)) {
            this.clearBlock(this.mBuf);
            this.clearBlock(block);
            return false;
        }
        this.clearBlock(this.mBuf);
        this.clearBlock(block);
        return true;
    }

    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }
}

