/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.jca.GetInstance;

public class KalkanSecurity {
    private static final Map<String, Class> spiMap = new ConcurrentHashMap<String, Class>();

    public static Class getSpiClass(String type) {
        Class<?> clazz = spiMap.get(type);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName("javax.crypto." + type + "Spi");
            spiMap.put(type, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Spi class not found"))).initCause(e);
        }
    }

    public static Object[] getImpl(String algorithm, String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            return GetInstance.getInstance(type, KalkanSecurity.getSpiClass(type), algorithm).toArray();
        }
        return GetInstance.getInstance(type, KalkanSecurity.getSpiClass(type), algorithm, provider).toArray();
    }

    public static Object[] getImpl(String algorithm, String type, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(type, KalkanSecurity.getSpiClass(type), algorithm, provider).toArray();
    }
}

