/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import kz.gov.pki.kalkan.crypto.CipherParameters;
import kz.gov.pki.kalkan.crypto.PBEParametersGenerator;
import kz.gov.pki.kalkan.crypto.digests.MD5Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.crypto.generators.PKCS12ParametersGenerator;
import kz.gov.pki.kalkan.crypto.generators.PKCS5S1ParametersGenerator;
import kz.gov.pki.kalkan.crypto.generators.PKCS5S2ParametersGenerator;
import kz.gov.pki.kalkan.crypto.params.KeyParameter;
import kz.gov.pki.kalkan.crypto.params.ParametersWithIV;
import kz.gov.pki.kalkan.jce.provider.JCEPBEKey;
import kz.gov.pki.kalkan.jce.provider.OldPKCS12ParametersGenerator;

public interface BrokenPBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OLD_PKCS12 = 3;

    public static class Util {
        private static void setOddParity(byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                bytes[i] = (byte)(b & 0xFE | b >> 1 ^ b >> 2 ^ b >> 3 ^ b >> 4 ^ b >> 5 ^ b >> 6 ^ b >> 7 ^ 1);
            }
        }

        private static PBEParametersGenerator makePBEGenerator(int type, int hash) {
            PBEParametersGenerator generator;
            block13: {
                block15: {
                    block14: {
                        block12: {
                            if (type != 0) break block12;
                            switch (hash) {
                                case 0: {
                                    generator = new PKCS5S1ParametersGenerator(new MD5Digest());
                                    break block13;
                                }
                                case 1: {
                                    generator = new PKCS5S1ParametersGenerator(new SHA1Digest());
                                    break block13;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports only MD5 and SHA1.");
                                }
                            }
                        }
                        if (type != 1) break block14;
                        generator = new PKCS5S2ParametersGenerator();
                        break block13;
                    }
                    if (type != 3) break block15;
                    switch (hash) {
                        case 0: {
                            generator = new OldPKCS12ParametersGenerator(new MD5Digest());
                            break block13;
                        }
                        case 1: {
                            generator = new OldPKCS12ParametersGenerator(new SHA1Digest());
                            break block13;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                switch (hash) {
                    case 0: {
                        generator = new PKCS12ParametersGenerator(new MD5Digest());
                        break;
                    }
                    case 1: {
                        generator = new PKCS12ParametersGenerator(new SHA1Digest());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                    }
                }
            }
            return generator;
        }

        static CipherParameters makePBEParameters(JCEPBEKey pbeKey, AlgorithmParameterSpec spec, int type, int hash, String targetAlgorithm, int keySize, int ivSize) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = pbeKey.getEncoded();
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = ivSize != 0 ? generator.generateDerivedParameters(keySize, ivSize) : generator.generateDerivedParameters(keySize);
            if (targetAlgorithm.startsWith("DES")) {
                KeyParameter kParam;
                if (param instanceof ParametersWithIV) {
                    kParam = (KeyParameter)((ParametersWithIV)param).getParameters();
                    Util.setOddParity(kParam.getKey());
                } else {
                    kParam = (KeyParameter)param;
                    Util.setOddParity(kParam.getKey());
                }
            }
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEMacParameters(JCEPBEKey pbeKey, AlgorithmParameterSpec spec, int type, int hash, int keySize) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = pbeKey.getEncoded();
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }
    }
}

