/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERBitString;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.cryptopro.ECGOST3410NamedCurves;
import kz.gov.pki.kalkan.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.asn1.x9.X962Parameters;
import kz.gov.pki.kalkan.asn1.x9.X9ECParameters;
import kz.gov.pki.kalkan.asn1.x9.X9ECPoint;
import kz.gov.pki.kalkan.asn1.x9.X9IntegerConverter;
import kz.gov.pki.kalkan.asn1.x9.X9ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.crypto.params.ECPublicKeyParameters;
import kz.gov.pki.kalkan.jce.ECGOST3410NamedCurveTable;
import kz.gov.pki.kalkan.jce.interfaces.ECPointEncoder;
import kz.gov.pki.kalkan.jce.provider.KalkanGOST3410GTPublicKey;
import kz.gov.pki.kalkan.jce.provider.ProviderUtil;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.EC5Util;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.ECUtil;
import kz.gov.pki.kalkan.jce.spec.ECNamedCurveParameterSpec;
import kz.gov.pki.kalkan.jce.spec.ECNamedCurveSpec;
import kz.gov.pki.kalkan.math.ec.ECCurve;
import kz.gov.pki.kalkan.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey,
kz.gov.pki.kalkan.jce.interfaces.ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;
    private DERObjectIdentifier algOid = null;
    private byte[] plainKeyBytes = null;

    public JCEECPublicKey(String algorithm, JCEECPublicKey key) {
        this.algorithm = algorithm;
        this.q = key.q;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.gostParams = key.gostParams;
        if (key.algOid != null) {
            this.algOid = new DERObjectIdentifier(key.algOid.getId());
        }
        if (key.plainKeyBytes != null) {
            this.plainKeyBytes = new byte[key.plainKeyBytes.length];
            System.arraycopy(key.plainKeyBytes, 0, this.plainKeyBytes, 0, this.plainKeyBytes.length);
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.ecSpec = spec.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, spec.getW(), false);
    }

    public JCEECPublicKey(String algorithm, kz.gov.pki.kalkan.jce.spec.ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.q = spec.getQ();
        if (spec.getParams() != null) {
            ECCurve curve = spec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, spec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec.getParams());
        } else {
            if (this.q.getCurve() == null) {
                kz.gov.pki.kalkan.jce.spec.ECParameterSpec s = ProviderUtil.getEcImplicitlyCa();
                this.q = s.getCurve().createPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        if (spec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, dp);
        } else {
            this.ecSpec = spec;
            this.algOid = KNCAObjectIdentifiers.gost34310_2004;
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params, kz.gov.pki.kalkan.jce.spec.ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        if (spec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, dp);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(spec.getCurve(), spec.getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec);
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params) {
        this.algorithm = algorithm;
        this.q = params.getQ();
        if (this.algorithm.compareTo("ECGOST34310") == 0) {
            BigInteger gtParam1 = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639319");
            ECNamedCurveParameterSpec spec = ECGOST3410NamedCurveTable.getParameterSpec("GostR34310_2004");
            ECCurve.Fp curve = new ECCurve.Fp(gtParam1, new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639316"), new BigInteger("166"));
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, spec.getSeed());
            this.ecSpec = new ECNamedCurveSpec("GostR34310_2004", ellipticCurve, new java.security.spec.ECPoint(spec.getG().getX().toBigInteger(), spec.getG().getY().toBigInteger()), spec.getN(), spec.getH());
            this.algOid = CryptoProObjectIdentifiers.gostR34310_2004;
        } else {
            this.ecSpec = null;
        }
    }

    private ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters dp) {
        return new ECParameterSpec(ellipticCurve, new java.security.spec.ECPoint(dp.getG().getX().toBigInteger(), dp.getG().getY().toBigInteger()), dp.getN(), dp.getH().intValue());
    }

    public JCEECPublicKey(ECPublicKey key) {
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, key.getW(), false);
    }

    JCEECPublicKey(SubjectPublicKeyInfo info) {
        this.populateFromPubKeyInfo(info);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo info) {
        if (info.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001) || info.getAlgorithmId().getObjectId().equals(KNCAObjectIdentifiers.gost34310_2004) || info.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR34310_2004) || info.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004)) {
            DERBitString bits = info.getPublicKeyData();
            ASN1OctetString key = null;
            this.algorithm = "ECGOST34310";
            this.algOid = new DERObjectIdentifier(info.getAlgorithmId().getObjectId().getId());
            ASN1InputStream keyStream = new ASN1InputStream(bits.getBytes());
            KalkanGOST3410GTPublicKey gtPublicKey = KalkanGOST3410GTPublicKey.getInstance();
            ECNamedCurveParameterSpec spec = null;
            EllipticCurve ellipticCurve = null;
            if (gtPublicKey.checkOpenKeyBlob(bits.getBytes())) {
                BigInteger b;
                BigInteger a;
                BigInteger mod_p;
                gtPublicKey.setKeyBlob(bits.getBytes());
                if (gtPublicKey.getKeyBlobByte().length == 64) {
                    mod_p = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639319");
                    a = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639316");
                    b = new BigInteger("166");
                    spec = ECGOST3410NamedCurveTable.getParameterSpec("GostR34310_2004");
                } else {
                    mod_p = new BigInteger("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319");
                    a = new BigInteger("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112316");
                    b = new BigInteger("27580193559959705877849011840389048093056905856361568521428707301988689241309860865136260764883745107765439761230575");
                    spec = ECGOST3410NamedCurveTable.getParameterSpec("Gost34310_2004_384");
                }
                ECCurve.Fp curve = new ECCurve.Fp(mod_p, a, b);
                ellipticCurve = EC5Util.convertCurve(curve, spec.getSeed());
                this.q = ((ECCurve)curve).createPoint(gtPublicKey.getKeyX(), gtPublicKey.getKeyY(), false);
                this.ecSpec = new ECNamedCurveSpec("GostR34310_2004", ellipticCurve, new java.security.spec.ECPoint(spec.getG().getX().toBigInteger(), spec.getG().getY().toBigInteger()), spec.getN(), spec.getH());
                byte[] keyBytes = bits.getBytes();
                this.plainKeyBytes = new byte[keyBytes.length];
                System.arraycopy(keyBytes, 0, this.plainKeyBytes, 0, keyBytes.length);
            } else {
                int i;
                try {
                    key = (ASN1OctetString)keyStream.readObject();
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("error recovering public key");
                }
                byte[] keyEnc = key.getOctets();
                byte[] x = new byte[32];
                byte[] y = new byte[32];
                for (i = 0; i != x.length; ++i) {
                    x[i] = keyEnc[31 - i];
                }
                for (i = 0; i != y.length; ++i) {
                    y[i] = keyEnc[63 - i];
                }
                this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)info.getAlgorithmId().getParameters());
                spec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
                ECCurve curve = spec.getCurve();
                ellipticCurve = EC5Util.convertCurve(curve, spec.getSeed());
                this.q = curve.createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
                this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()), ellipticCurve, new java.security.spec.ECPoint(spec.getG().getX().toBigInteger(), spec.getG().getY().toBigInteger()), spec.getN(), spec.getH());
            }
        } else {
            int qLength;
            ECCurve curve;
            X962Parameters params = new X962Parameters((DERObject)info.getAlgorithmId().getParameters());
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
                curve = ecP.getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
                this.ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName(oid), ellipticCurve, new java.security.spec.ECPoint(ecP.getG().getX().toBigInteger(), ecP.getG().getY().toBigInteger()), ecP.getN(), ecP.getH());
            } else if (params.isImplicitlyCA()) {
                this.ecSpec = null;
                curve = ProviderUtil.getEcImplicitlyCa().getCurve();
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                curve = ecP.getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
                this.ecSpec = new ECParameterSpec(ellipticCurve, new java.security.spec.ECPoint(ecP.getG().getX().toBigInteger(), ecP.getG().getY().toBigInteger()), ecP.getN(), ecP.getH().intValue());
            }
            DERBitString bits = info.getPublicKeyData();
            byte[] data = bits.getBytes();
            ASN1OctetString key = new DEROctetString(data);
            if (data[0] == 4 && data[1] == data.length - 2 && (data[2] == 2 || data[2] == 3) && (qLength = new X9IntegerConverter().getByteLength(curve)) >= data.length - 3) {
                try {
                    key = (ASN1OctetString)ASN1Object.fromByteArray(data);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint derQ = new X9ECPoint(curve, key);
            this.q = derQ.getPoint();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        SubjectPublicKeyInfo info;
        if (this.algorithm.equals("ECGOST3410") || this.algorithm.equals("ECGOST34310")) {
            ASN1Encodable params;
            if (this.gostParams != null) {
                params = this.gostParams;
            } else if (this.ecSpec instanceof ECNamedCurveSpec) {
                params = this.algOid != null && (this.algOid.equals(CryptoProObjectIdentifiers.gostR34310_2004) || this.algOid.equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004)) ? null : new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()), KNCAObjectIdentifiers.gost34311_95_TestParamSet);
            } else {
                ECCurve curve = EC5Util.convertCurve(this.ecSpec.getCurve());
                X9ECParameters ecP = new X9ECParameters(curve, EC5Util.convertPoint(curve, this.ecSpec.getGenerator(), this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
                params = new X962Parameters(ecP);
            }
            BigInteger bX = this.q.getX().toBigInteger();
            BigInteger bY = this.q.getY().toBigInteger();
            byte[] encKey = new byte[64];
            this.extractBytes(encKey, 0, bX);
            this.extractBytes(encKey, 32, bY);
            byte[] tempEncKey = new byte[64];
            int k = 0;
            for (int i = encKey.length - 1; i >= 0; --i) {
                tempEncKey[k] = encKey[i];
                ++k;
            }
            if (this.algOid != null && (this.algOid.equals(CryptoProObjectIdentifiers.gostR34310_2004) || this.algOid.equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004))) {
                int i;
                byte[] temp = new byte[]{6, 2, 0, 0, 58, -86, 0, 0, 0, 69, 67, 49, 0, 2, 0, 0};
                byte[] encKey2 = new byte[temp.length + encKey.length];
                for (i = 0; i < temp.length; ++i) {
                    encKey2[i] = temp[i];
                }
                for (i = temp.length; i < encKey2.length; ++i) {
                    encKey2[i] = encKey[i - temp.length];
                }
                info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR34310_2004, null), encKey2);
            } else {
                info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(KNCAObjectIdentifiers.gost34310_2004, params.getDERObject()), new DEROctetString(encKey));
            }
        } else {
            ECCurve curve;
            X962Parameters params;
            if (this.ecSpec instanceof ECNamedCurveSpec) {
                DERObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)this.ecSpec).getName());
                params = new X962Parameters(curveOid);
            } else if (this.ecSpec == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                curve = EC5Util.convertCurve(this.ecSpec.getCurve());
                X9ECParameters ecP = new X9ECParameters(curve, EC5Util.convertPoint(curve, this.ecSpec.getGenerator(), this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
                params = new X962Parameters(ecP);
            }
            curve = this.engineGetQ().getCurve();
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(curve.createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), this.withCompression)).getDERObject();
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params.getDERObject()), p.getOctets());
        }
        return info.getDEREncoded();
    }

    private void extractBytes(byte[] encKey, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < 32) {
            byte[] tmp = new byte[32];
            System.arraycopy(val, 0, encKey, 32, val.length);
            return;
        }
        for (int i = 0; i != 32; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public kz.gov.pki.kalkan.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(this.ecSpec, this.withCompression);
    }

    public java.security.spec.ECPoint getW() {
        return new java.security.spec.ECPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger());
    }

    public ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    public ECPoint engineGetQ() {
        return this.q;
    }

    kz.gov.pki.kalkan.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec, this.withCompression);
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("EC Public Key").append(nl);
        buf.append("            X: ").append(this.q.getX().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(this.q.getY().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCEECPublicKey)) {
            return false;
        }
        JCEECPublicKey other = (JCEECPublicKey)o;
        boolean result = false;
        result = this.engineGetQ().equals(other.engineGetQ()) && this.engineGetSpec().equals(other.engineGetSpec());
        return result;
    }

    public int hashCode() {
        return this.engineGetQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(enc)));
        this.algorithm = (String)in.readObject();
        this.withCompression = in.readBoolean();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getEncoded());
        out.writeObject(this.algorithm);
        out.writeBoolean(this.withCompression);
    }

    public String getAlgOid() {
        return this.algOid == null ? null : new String(this.algOid.getId());
    }

    public byte[] getKeyBytes() {
        if (this.algOid.equals(CryptoProObjectIdentifiers.gostR34310_2004) || this.algOid.equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004)) {
            return this.plainKeyBytes;
        }
        BigInteger bX = this.q.getX().toBigInteger();
        BigInteger bY = this.q.getY().toBigInteger();
        byte[] encKey = new byte[64];
        this.extractBytes(encKey, 0, bX);
        this.extractBytes(encKey, 32, bY);
        return encKey;
    }

    public byte[] getParamsBytes() {
        byte[] result = null;
        try {
            result = this.gostParams == null ? null : this.gostParams.getEncoded();
        }
        catch (IOException e) {
            e.toString();
            return null;
        }
        return result;
    }
}

