/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import kz.gov.pki.kalkan.crypto.BlockCipher;
import kz.gov.pki.kalkan.crypto.CipherParameters;
import kz.gov.pki.kalkan.crypto.Mac;
import kz.gov.pki.kalkan.crypto.digests.MD2Digest;
import kz.gov.pki.kalkan.crypto.digests.MD4Digest;
import kz.gov.pki.kalkan.crypto.digests.MD5Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA224Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA256Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA384Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA512Digest;
import kz.gov.pki.kalkan.crypto.engines.DESEngine;
import kz.gov.pki.kalkan.crypto.engines.DESedeEngine;
import kz.gov.pki.kalkan.crypto.engines.RC2Engine;
import kz.gov.pki.kalkan.crypto.engines.RC532Engine;
import kz.gov.pki.kalkan.crypto.macs.CBCBlockCipherMac;
import kz.gov.pki.kalkan.crypto.macs.CFBBlockCipherMac;
import kz.gov.pki.kalkan.crypto.macs.GOST28147Mac;
import kz.gov.pki.kalkan.crypto.macs.HMac;
import kz.gov.pki.kalkan.crypto.macs.ISO9797Alg3Mac;
import kz.gov.pki.kalkan.crypto.macs.OldHMac;
import kz.gov.pki.kalkan.crypto.paddings.ISO7816d4Padding;
import kz.gov.pki.kalkan.crypto.params.KeyParameter;
import kz.gov.pki.kalkan.crypto.params.ParametersWithIV;
import kz.gov.pki.kalkan.jce.provider.JCEPBEKey;
import kz.gov.pki.kalkan.jce.provider.PBE;

public class JCEMac
extends MacSpi
implements PBE {
    private Mac macEngine;
    private int pbeType = 2;
    private int pbeHash = 1;
    private int keySize = 160;

    protected JCEMac(Mac macEngine) {
        this.macEngine = macEngine;
    }

    protected JCEMac(Mac macEngine, int pbeType, int pbeHash, int keySize) {
        this.macEngine = macEngine;
        this.pbeType = pbeType;
        this.pbeHash = pbeHash;
        this.keySize = keySize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof JCEPBEKey) {
            JCEPBEKey k = (JCEPBEKey)key;
            if (k.getParam() != null) {
                param = k.getParam();
            } else {
                if (!(params instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                param = PBE.Util.makePBEMacParameters(k, params);
            }
        } else if (params instanceof IvParameterSpec) {
            param = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)params).getIV());
        } else {
            if (params != null) throw new InvalidAlgorithmParameterException("unknown parameter type.");
            param = new KeyParameter(key.getEncoded());
        }
        this.macEngine.init(param);
    }

    protected int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    protected void engineReset() {
        this.macEngine.reset();
    }

    protected void engineUpdate(byte input) {
        this.macEngine.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.macEngine.update(input, offset, len);
    }

    protected byte[] engineDoFinal() {
        byte[] out = new byte[this.engineGetMacLength()];
        this.macEngine.doFinal(out, 0);
        return out;
    }

    public static class PBEWithSHAPublic
    extends PBEWithSHA {
        public void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.engineInit(key, params);
        }
    }

    public static class PBEWithSHA
    extends JCEMac {
        public PBEWithSHA() {
            super(new HMac(new SHA1Digest()), 2, 1, 160);
        }
    }

    public static class OldSHA512
    extends JCEMac {
        public OldSHA512() {
            super(new OldHMac(new SHA512Digest()));
        }
    }

    public static class SHA512
    extends JCEMac {
        public SHA512() {
            super(new HMac(new SHA512Digest()));
        }
    }

    public static class OldSHA384
    extends JCEMac {
        public OldSHA384() {
            super(new OldHMac(new SHA384Digest()));
        }
    }

    public static class SHA384
    extends JCEMac {
        public SHA384() {
            super(new HMac(new SHA384Digest()));
        }
    }

    public static class SHA256
    extends JCEMac {
        public SHA256() {
            super(new HMac(new SHA256Digest()));
        }
    }

    public static class SHA224
    extends JCEMac {
        public SHA224() {
            super(new HMac(new SHA224Digest()));
        }
    }

    public static class SHA1
    extends JCEMac {
        public SHA1() {
            super(new HMac(new SHA1Digest()));
        }
    }

    public static class MD5
    extends JCEMac {
        public MD5() {
            super(new HMac(new MD5Digest()));
        }
    }

    public static class MD4
    extends JCEMac {
        public MD4() {
            super(new HMac(new MD4Digest()));
        }
    }

    public static class MD2
    extends JCEMac {
        public MD2() {
            super(new HMac(new MD2Digest()));
        }
    }

    public static class DES9797Alg3
    extends JCEMac {
        public DES9797Alg3() {
            super(new ISO9797Alg3Mac(new DESEngine()));
        }
    }

    public static class DES9797Alg3with7816d4
    extends JCEMac {
        public DES9797Alg3with7816d4() {
            super(new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding()));
        }
    }

    public static class DESede64with7816d4
    extends JCEMac {
        public DESede64with7816d4() {
            super(new CBCBlockCipherMac(new DESedeEngine(), 64, new ISO7816d4Padding()));
        }
    }

    public static class DESede64
    extends JCEMac {
        public DESede64() {
            super(new CBCBlockCipherMac((BlockCipher)new DESedeEngine(), 64));
        }
    }

    public static class RC5CFB8
    extends JCEMac {
        public RC5CFB8() {
            super(new CFBBlockCipherMac(new RC532Engine()));
        }
    }

    public static class RC2CFB8
    extends JCEMac {
        public RC2CFB8() {
            super(new CFBBlockCipherMac(new RC2Engine()));
        }
    }

    public static class DESedeCFB8
    extends JCEMac {
        public DESedeCFB8() {
            super(new CFBBlockCipherMac(new DESedeEngine()));
        }
    }

    public static class DESCFB8
    extends JCEMac {
        public DESCFB8() {
            super(new CFBBlockCipherMac(new DESEngine()));
        }
    }

    public static class GOST28147
    extends JCEMac {
        public GOST28147() {
            super(new GOST28147Mac());
        }
    }

    public static class RC5
    extends JCEMac {
        public RC5() {
            super(new CBCBlockCipherMac(new RC532Engine()));
        }
    }

    public static class RC2
    extends JCEMac {
        public RC2() {
            super(new CBCBlockCipherMac(new RC2Engine()));
        }
    }

    public static class DESede
    extends JCEMac {
        public DESede() {
            super(new CBCBlockCipherMac(new DESedeEngine()));
        }
    }

    public static class DES
    extends JCEMac {
        public DES() {
            super(new CBCBlockCipherMac(new DESEngine()));
        }
    }
}

