/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.DSA;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.digests.GOST3411Digest;
import kz.gov.pki.kalkan.crypto.digests.NullDigest;
import kz.gov.pki.kalkan.crypto.params.AsymmetricKeyParameter;
import kz.gov.pki.kalkan.crypto.params.ParametersWithRandom;
import kz.gov.pki.kalkan.crypto.signers.ECGOST3410Signer;
import kz.gov.pki.kalkan.crypto.signers.GOST3410Signer;
import kz.gov.pki.kalkan.jce.interfaces.ECKey;
import kz.gov.pki.kalkan.jce.interfaces.ECPublicKey;
import kz.gov.pki.kalkan.jce.interfaces.GOST3410Key;
import kz.gov.pki.kalkan.jce.provider.GOST3410Util;
import kz.gov.pki.kalkan.jce.provider.JDKKeyFactory;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.ECUtil;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.ByteUtils;

public class JDKGOST3410Signer
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    protected Digest digest;
    private DSA signer;
    protected SecureRandom random;
    private byte keyId;
    private AKToken token = null;
    private String sigAlg;

    protected JDKGOST3410Signer(Digest digest, DSA signer) {
        this.digest = digest;
        this.signer = signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        if (publicKey instanceof ECPublicKey) {
            param = ECUtil.generatePublicKeyParameter(publicKey);
        } else if (publicKey instanceof GOST3410Key) {
            param = GOST3410Util.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = JDKKeyFactory.createPublicKeyFromDERStream(bytes);
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                param = ECUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception e) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        this.digest.reset();
        this.signer.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        this.digest.reset();
        if (privateKey instanceof ECKey) {
            param = ECUtil.generatePrivateKeyParameter(privateKey);
        } else {
            if (privateKey instanceof AKGOST34310PrivateKey) {
                AKGOST34310PrivateKey key = (AKGOST34310PrivateKey)privateKey;
                this.keyId = key.getKeyId();
                this.token = key.getToken();
                this.sigAlg = "GOST";
                return;
            }
            param = GOST3410Util.generatePrivateKeyParameter(privateKey);
        }
        if (this.random != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.random));
        } else {
            this.signer.init(true, param);
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            if (this.token == null) {
                byte[] sigBytes = new byte[64];
                BigInteger[] sig = this.signer.generateSignature(hash);
                byte[] r = sig[0].toByteArray();
                byte[] s = sig[1].toByteArray();
                if (s[0] != 0) {
                    System.arraycopy(s, 0, sigBytes, 32 - s.length, s.length);
                } else {
                    System.arraycopy(s, 1, sigBytes, 32 - (s.length - 1), s.length - 1);
                }
                if (r[0] != 0) {
                    System.arraycopy(r, 0, sigBytes, 64 - r.length, r.length);
                } else {
                    System.arraycopy(r, 1, sigBytes, 64 - (r.length - 1), r.length - 1);
                }
                byte[] reversedSigBytes = ByteUtils.inverseCopyByte(sigBytes, 0, sigBytes.length);
                return reversedSigBytes;
            }
            return this.token.sign(this.sigAlg, hash, this.keyId);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] s;
        byte[] r;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        BigInteger[] sig = null;
        boolean result = false;
        int half = sigBytes.length / 2;
        try {
            r = new byte[half];
            s = new byte[half];
            System.arraycopy(sigBytes, 0, s, 0, half);
            System.arraycopy(sigBytes, half, r, 0, half);
            sig = new BigInteger[]{new BigInteger(1, r), new BigInteger(1, s)};
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException("error decoding signature bytes.");
        }
        result = this.signer.verifySignature(hash, sig[0], sig[1]);
        if (result) {
            return true;
        }
        try {
            r = new byte[half];
            s = new byte[half];
            byte[] reversedSigBytes = ByteUtils.inverseCopyByte(sigBytes, 0, sigBytes.length);
            System.arraycopy(reversedSigBytes, 0, s, 0, half);
            System.arraycopy(reversedSigBytes, half, r, 0, half);
            sig = new BigInteger[]{new BigInteger(1, r), new BigInteger(1, s)};
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException("error decoding signature bytes.");
        }
        result = this.signer.verifySignature(hash, sig[0], sig[1]);
        return result;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class noneECGOST34310
    extends JDKGOST3410Signer {
        public noneECGOST34310() {
            super(new NullDigest(), new ECGOST3410Signer());
        }
    }

    public static class ecgost3410
    extends JDKGOST3410Signer {
        public ecgost3410() {
            super(new GOST3411Digest(), new ECGOST3410Signer());
        }
    }

    public static class gost3410
    extends JDKGOST3410Signer {
        public gost3410() {
            super(new GOST3411Digest(), new GOST3410Signer());
        }
    }
}

