/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.digests.KalkanGOST3411Digest;
import kz.gov.pki.kalkan.jce.provider.JCEECPrivateKey;
import kz.gov.pki.kalkan.jce.provider.JCEECPublicKey;

public class JDKKalkanGOST3410Signer
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    Digest digest = null;
    byte[] publicKeyBytes = null;
    byte[] privateKeyBytes = null;
    String publicKeyAlgOid = "";
    byte[] publicKeyParams = null;

    private native int SignHash(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int[] var6);

    private native int VerifyHashEx(byte[] var1, int var2, String var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9);

    protected JDKKalkanGOST3410Signer(Digest digest) {
        this.digest = digest;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof JCEECPublicKey)) {
            throw new InvalidKeyException("Can't recognize key " + publicKey.toString());
        }
        this.publicKeyBytes = ((JCEECPublicKey)publicKey).getKeyBytes();
        this.publicKeyAlgOid = ((JCEECPublicKey)publicKey).getAlgOid();
        this.publicKeyParams = ((JCEECPublicKey)publicKey).getParamsBytes();
        this.digest.reset();
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof JCEECPrivateKey)) {
            throw new InvalidKeyException("Can't recognize key " + privateKey.toString());
        }
        this.privateKeyBytes = privateKey.getEncoded();
        this.digest.reset();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.privateKeyBytes == null) {
            throw new SignatureException("The private key is empty");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        int[] signSize = new int[16];
        signSize[0] = 64;
        byte[] signature = new byte[signSize[0]];
        int result = this.SignHash(hash, hash.length, this.privateKeyBytes, this.privateKeyBytes.length, signature, signSize);
        if (result != 0) {
            throw new SignatureException("Signature error: " + new Integer(result).toString());
        }
        return signature;
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.publicKeyBytes == null) {
            throw new SignatureException("The public key is empty");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        int paramsLen = 0;
        if (this.publicKeyParams == null) {
            this.publicKeyParams = new byte[1];
            this.publicKeyParams[0] = 0;
        } else {
            paramsLen = this.publicKeyParams.length;
        }
        int[] signSize = new int[16];
        signSize[0] = sigBytes.length;
        int result = this.VerifyHashEx(hash, hash.length, this.publicKeyAlgOid, this.publicKeyParams, paramsLen, this.publicKeyBytes, this.publicKeyBytes.length, sigBytes, signSize);
        if (result < 0) {
            throw new SignatureException("Verify error");
        }
        return result == 0;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class Kalkanecgost3410
    extends JDKKalkanGOST3410Signer {
        public Kalkanecgost3410() {
            super(new KalkanGOST3411Digest());
        }
    }
}

