/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.jce.provider.JDKKalkanRSAPrivateKey;
import kz.gov.pki.kalkan.util.ByteUtils;

public class JDKKalkanRSASignature
extends SignatureSpi {
    private Digest digest = new SHA1Digest();
    private JDKKalkanRSAPrivateKey privKey = null;
    private PublicKey pubKey = null;
    private static final int HashAlg = 32772;

    private native int SignHash(byte[] var1, int var2, int var3, byte[] var4, int var5, byte[] var6, int[] var7);

    private native int VerifyHash(byte[] var1, int var2, int var3, byte[] var4, int var5, byte[] var6, int var7);

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(publicKey) + ") is not a RSAPublicKey instance");
        }
        this.pubKey = publicKey;
        this.digest.reset();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof JDKKalkanRSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(privateKey) + ") is not a JDKKalkanRSAPrivateKey instance");
        }
        this.privKey = (JDKKalkanRSAPrivateKey)privateKey;
        this.digest.reset();
    }

    private String getType(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.privKey == null) {
            throw new SignatureException("Signer is not ready: private key is empty");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        int[] signSize = new int[16];
        signSize[0] = 1024;
        byte[] signature = new byte[signSize[0]];
        byte[] privateKeyBytes = this.privKey.getEncoded();
        int result = this.SignHash(hash, hash.length, 32772, privateKeyBytes, privateKeyBytes.length, signature, signSize);
        if (result != 0) {
            throw new SignatureException("Signature error: " + new Integer(result).toString());
        }
        byte[] sigBytes = new byte[signSize[0]];
        System.arraycopy(signature, 0, sigBytes, 0, signSize[0]);
        byte[] reversedSigBytes = ByteUtils.inverseCopyByte(sigBytes, 0, sigBytes.length);
        return reversedSigBytes;
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] reversedSigBytes = ByteUtils.inverseCopyByte(sigBytes, 0, sigBytes.length);
        if (this.pubKey == null) {
            throw new SignatureException("Signer is not ready: public key is empty");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        byte[] key = this.pubKey.getEncoded();
        int toStrip = key.length >= 293 ? 24 : 22;
        byte[] strippedKey = new byte[key.length - toStrip];
        System.arraycopy(key, 0, strippedKey, 0, 2);
        System.arraycopy(key, toStrip + 2, strippedKey, 2, key.length - toStrip - 2);
        int result = this.VerifyHash(hash, hash.length, 32772, strippedKey, strippedKey.length, reversedSigBytes, reversedSigBytes.length);
        if (result < 0) {
            throw new SignatureException("Verify error");
        }
        return result == 0;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }
}

