/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.security.MessageDigest;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.digests.GOST3411Digest;
import kz.gov.pki.kalkan.crypto.digests.GOSTR341194Digest;
import kz.gov.pki.kalkan.crypto.digests.MD2Digest;
import kz.gov.pki.kalkan.crypto.digests.MD4Digest;
import kz.gov.pki.kalkan.crypto.digests.MD5Digest;
import kz.gov.pki.kalkan.crypto.digests.NullDigest;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA224Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA256Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA384Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA512Digest;

public class JDKMessageDigest
extends MessageDigest {
    Digest digest;

    protected JDKMessageDigest(Digest digest) {
        super(digest.getAlgorithmName());
        this.digest = digest;
    }

    public void engineReset() {
        this.digest.reset();
    }

    public void engineUpdate(byte input) {
        this.digest.update(input);
    }

    public void engineUpdate(byte[] input, int offset, int len) {
        this.digest.update(input, offset, len);
    }

    public byte[] engineDigest() {
        byte[] digestBytes = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(digestBytes, 0);
        return digestBytes;
    }

    public static class NULL
    extends JDKMessageDigest
    implements Cloneable {
        public NULL() {
            super(new NullDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            NULL d = (NULL)super.clone();
            d.digest = new NullDigest((NullDigest)this.digest);
            return d;
        }
    }

    public static class GOSTR341194
    extends JDKMessageDigest
    implements Cloneable {
        public GOSTR341194() {
            super(new GOSTR341194Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            GOSTR341194 d = (GOSTR341194)super.clone();
            d.digest = new GOSTR341194Digest((GOSTR341194Digest)this.digest);
            return d;
        }
    }

    public static class GOST3411
    extends JDKMessageDigest
    implements Cloneable {
        public GOST3411() {
            super(new GOST3411Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            GOST3411 d = (GOST3411)super.clone();
            d.digest = new GOST3411Digest((GOST3411Digest)this.digest);
            return d;
        }
    }

    public static class MD5
    extends JDKMessageDigest
    implements Cloneable {
        public MD5() {
            super(new MD5Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            MD5 d = (MD5)super.clone();
            d.digest = new MD5Digest((MD5Digest)this.digest);
            return d;
        }
    }

    public static class MD4
    extends JDKMessageDigest
    implements Cloneable {
        public MD4() {
            super(new MD4Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            MD4 d = (MD4)super.clone();
            d.digest = new MD4Digest((MD4Digest)this.digest);
            return d;
        }
    }

    public static class MD2
    extends JDKMessageDigest
    implements Cloneable {
        public MD2() {
            super(new MD2Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            MD2 d = (MD2)super.clone();
            d.digest = new MD2Digest((MD2Digest)this.digest);
            return d;
        }
    }

    public static class SHA512
    extends JDKMessageDigest
    implements Cloneable {
        public SHA512() {
            super(new SHA512Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA512 d = (SHA512)super.clone();
            d.digest = new SHA512Digest((SHA512Digest)this.digest);
            return d;
        }
    }

    public static class SHA384
    extends JDKMessageDigest
    implements Cloneable {
        public SHA384() {
            super(new SHA384Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA384 d = (SHA384)super.clone();
            d.digest = new SHA384Digest((SHA384Digest)this.digest);
            return d;
        }
    }

    public static class SHA256
    extends JDKMessageDigest
    implements Cloneable {
        public SHA256() {
            super(new SHA256Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA256 d = (SHA256)super.clone();
            d.digest = new SHA256Digest((SHA256Digest)this.digest);
            return d;
        }
    }

    public static class SHA224
    extends JDKMessageDigest
    implements Cloneable {
        public SHA224() {
            super(new SHA224Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA224 d = (SHA224)super.clone();
            d.digest = new SHA224Digest((SHA224Digest)this.digest);
            return d;
        }
    }

    public static class SHA1
    extends JDKMessageDigest
    implements Cloneable {
        public SHA1() {
            super(new SHA1Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            SHA1 d = (SHA1)super.clone();
            d.digest = new SHA1Digest((SHA1Digest)this.digest);
            return d;
        }
    }
}

