/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.pkcs.EncryptedPrivateKeyInfo;
import kz.gov.pki.kalkan.jce.provider.KeyProtector;
import kz.gov.pki.kalkan.util.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JavaKeyStore
extends KeyStoreSpi {
    private static final int MAGIC = -17957139;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private final Hashtable<String, Object> entries = new Hashtable();

    JavaKeyStore() {
    }

    abstract String convertAlias(String var1);

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        EncryptedPrivateKeyInfo encrInfo;
        Object entry = this.entries.get(this.convertAlias(alias));
        if (entry == null || !(entry instanceof KeyEntry)) {
            return null;
        }
        if (password == null) {
            throw new UnrecoverableKeyException("Password must not be null");
        }
        KeyProtector keyProtector = new KeyProtector(password);
        byte[] encrBytes = ((KeyEntry)entry).protectedPrivKey;
        try {
            ASN1InputStream asn1is = new ASN1InputStream(encrBytes);
            DERObject derObj = asn1is.readObject();
            asn1is.close();
            encrInfo = EncryptedPrivateKeyInfo.getInstance(derObj);
        }
        catch (IOException ioe) {
            throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
        }
        return keyProtector.recover(encrInfo);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Object entry = this.entries.get(this.convertAlias(alias));
        if (entry != null && entry instanceof KeyEntry) {
            if (((KeyEntry)entry).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)entry).chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Object entry = this.entries.get(this.convertAlias(alias));
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)entry).cert;
            }
            if (((KeyEntry)entry).chain == null) {
                return null;
            }
            return ((KeyEntry)entry).chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Object entry = this.entries.get(this.convertAlias(alias));
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)entry).date.getTime());
            }
            return new Date(((KeyEntry)entry).date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        KeyProtector keyProtector = null;
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("Cannot store non-PrivateKeys");
        }
        try {
            Hashtable<String, Object> hashtable = this.entries;
            synchronized (hashtable) {
                KeyEntry entry = new KeyEntry();
                entry.date = new Date();
                keyProtector = new KeyProtector(password);
                entry.protectedPrivKey = keyProtector.protect(key);
                if (chain != null && chain.length != 0) {
                    if (chain[0] != null) {
                        entry.chain = (Certificate[])chain.clone();
                    }
                } else {
                    entry.chain = null;
                }
                this.entries.put(this.convertAlias(alias), entry);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
        finally {
            keyProtector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            try {
                ASN1InputStream asn1is = new ASN1InputStream(key);
                DERObject derObj = asn1is.readObject();
                asn1is.close();
                EncryptedPrivateKeyInfo.getInstance(derObj);
            }
            catch (IOException ioe) {
                throw new KeyStoreException("key is not encoded as EncryptedPrivateKeyInfo");
            }
            KeyEntry entry = new KeyEntry();
            entry.date = new Date();
            entry.protectedPrivKey = (byte[])key.clone();
            entry.chain = chain != null && chain.length != 0 ? (Certificate[])chain.clone() : null;
            this.entries.put(this.convertAlias(alias), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(this.convertAlias(alias));
            if (entry != null && entry instanceof KeyEntry) {
                KeyEntry ke = (KeyEntry)entry;
                if (ke.chain == null || ke.chain.length == 0) {
                    ke.chain = new Certificate[1];
                    ke.chain[0] = cert;
                }
                this.entries.put(this.convertAlias(alias), ke);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(this.convertAlias(alias));
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(this.convertAlias(alias));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Object entry = this.entries.get(this.convertAlias(alias));
        return entry != null && entry instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        Object entry = this.entries.get(this.convertAlias(alias));
        return entry != null && entry instanceof TrustedCertEntry;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certificate;
            String alias = e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                Certificate certElem = ((TrustedCertEntry)entry).cert;
            } else {
                if (((KeyEntry)entry).chain == null) continue;
                certificate = ((KeyEntry)entry).chain[0];
            }
            if (!certificate.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            if (password == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest md = this.getPreKeyedHash(password);
            DataOutputStream dos = new DataOutputStream(new DigestOutputStream(stream, md));
            dos.writeInt(-17957139);
            dos.writeInt(2);
            dos.writeInt(this.entries.size());
            Enumeration<String> e = this.entries.keys();
            while (e.hasMoreElements()) {
                byte[] encoded;
                String alias = e.nextElement();
                Object entry = this.entries.get(alias);
                if (entry instanceof KeyEntry) {
                    dos.writeInt(1);
                    dos.writeUTF(alias);
                    dos.writeLong(((KeyEntry)entry).date.getTime());
                    dos.writeInt(((KeyEntry)entry).protectedPrivKey.length);
                    dos.write(((KeyEntry)entry).protectedPrivKey);
                    int chainLen = ((KeyEntry)entry).chain == null ? 0 : ((KeyEntry)entry).chain.length;
                    dos.writeInt(chainLen);
                    for (int i = 0; i < chainLen; ++i) {
                        encoded = ((KeyEntry)entry).chain[i].getEncoded();
                        dos.writeUTF(((KeyEntry)entry).chain[i].getType());
                        dos.writeInt(encoded.length);
                        dos.write(encoded);
                    }
                    continue;
                }
                dos.writeInt(2);
                dos.writeUTF(alias);
                dos.writeLong(((TrustedCertEntry)entry).date.getTime());
                encoded = ((TrustedCertEntry)entry).cert.getEncoded();
                dos.writeUTF(((TrustedCertEntry)entry).cert.getType());
                dos.writeInt(encoded.length);
                dos.write(encoded);
            }
            byte[] digest = md.digest();
            dos.write(digest);
            dos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            DataInputStream dis;
            MessageDigest md = null;
            CertificateFactory cf = null;
            Hashtable<String, CertificateFactory> cfs = null;
            ByteArrayInputStream bais = null;
            byte[] encoded = null;
            if (stream == null) {
                return;
            }
            if (password != null) {
                md = this.getPreKeyedHash(password);
                dis = new DataInputStream(new DigestInputStream(stream, md));
            } else {
                dis = new DataInputStream(stream);
            }
            int xMagic = dis.readInt();
            int xVersion = dis.readInt();
            if (xMagic != -17957139 || xVersion != 1 && xVersion != 2) {
                throw new IOException("Invalid keystore format");
            }
            if (xVersion == 1) {
                try {
                    cf = CertificateFactory.getInstance("X509", "KALKAN");
                }
                catch (NoSuchProviderException e) {
                    throw new NoSuchAlgorithmException(e);
                }
            } else {
                cfs = new Hashtable<String, CertificateFactory>(3);
            }
            this.entries.clear();
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                String alias;
                Object entry;
                int tag = dis.readInt();
                if (tag == 1) {
                    entry = new KeyEntry();
                    alias = dis.readUTF();
                    ((KeyEntry)entry).date = new Date(dis.readLong());
                    ((KeyEntry)entry).protectedPrivKey = new byte[dis.readInt()];
                    Streams.readFully(dis, ((KeyEntry)entry).protectedPrivKey, 0, ((KeyEntry)entry).protectedPrivKey.length);
                    int numOfCerts = dis.readInt();
                    if (numOfCerts > 0) {
                        ArrayList<Certificate> certs = new ArrayList<Certificate>(numOfCerts > 10 ? 10 : numOfCerts);
                        for (int j = 0; j < numOfCerts; ++j) {
                            if (xVersion == 2) {
                                String certType = dis.readUTF();
                                if (cfs.containsKey(certType)) {
                                    cf = (CertificateFactory)cfs.get(certType);
                                } else {
                                    try {
                                        cf = CertificateFactory.getInstance(certType, "KALKAN");
                                    }
                                    catch (NoSuchProviderException e) {
                                        throw new NoSuchAlgorithmException(e);
                                    }
                                    cfs.put(certType, cf);
                                }
                            }
                            encoded = new byte[dis.readInt()];
                            Streams.readFully(dis, encoded, 0, encoded.length);
                            bais = new ByteArrayInputStream(encoded);
                            certs.add(cf.generateCertificate(bais));
                            bais.close();
                        }
                        ((KeyEntry)entry).chain = certs.toArray(new Certificate[numOfCerts]);
                    }
                    this.entries.put(alias, entry);
                    continue;
                }
                if (tag == 2) {
                    entry = new TrustedCertEntry();
                    alias = dis.readUTF();
                    ((TrustedCertEntry)entry).date = new Date(dis.readLong());
                    if (xVersion == 2) {
                        String certType = dis.readUTF();
                        if (cfs.containsKey(certType)) {
                            cf = (CertificateFactory)cfs.get(certType);
                        } else {
                            try {
                                cf = CertificateFactory.getInstance(certType, "KALKAN");
                            }
                            catch (NoSuchProviderException e) {
                                throw new NoSuchAlgorithmException(e);
                            }
                            cfs.put(certType, cf);
                        }
                    }
                    encoded = new byte[dis.readInt()];
                    Streams.readFully(dis, encoded, 0, encoded.length);
                    bais = new ByteArrayInputStream(encoded);
                    ((TrustedCertEntry)entry).cert = cf.generateCertificate(bais);
                    bais.close();
                    this.entries.put(alias, entry);
                    continue;
                }
                throw new IOException("Unrecognized keystore entry");
            }
            if (password != null) {
                byte[] computed = md.digest();
                byte[] actual = new byte[computed.length];
                dis.readFully(actual);
                for (int i = 0; i < computed.length; ++i) {
                    if (computed[i] == actual[i]) continue;
                    UnrecoverableKeyException t = new UnrecoverableKeyException("Password verification failed");
                    throw (IOException)new IOException("Keystore was tampered with, or password was incorrect").initCause(t);
                }
            }
        }
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int i;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA", "KALKAN");
        }
        catch (NoSuchProviderException e) {
            throw new NoSuchAlgorithmException(e);
        }
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes("UTF8"));
        return md;
    }

    private static class TrustedCertEntry {
        Date date;
        Certificate cert;

        private TrustedCertEntry() {
        }
    }

    private static class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;

        private KeyEntry() {
        }
    }

    public static final class CaseExactJKS
    extends JavaKeyStore {
        String convertAlias(String alias) {
            return alias;
        }
    }

    public static final class JKS
    extends JavaKeyStore {
        String convertAlias(String alias) {
            return alias.toLowerCase(Locale.ENGLISH);
        }
    }
}

