/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Map;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.nist.NISTObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.oiw.OIWObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x9.X9ObjectIdentifiers;
import kz.gov.pki.kalkan.jce.interfaces.ConfigurableProvider;
import kz.gov.pki.kalkan.jce.provider.ProviderUtil;

public final class KalkanProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "Kalkan Provider";
    public static final String PROVIDER_NAME = "KALKAN";
    private static final double VERSION = 0.1;
    private static final String ASYMMETRIC_CIPHER_PACKAGE = "kz.gov.pki.kalkan.jce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"EC"};

    public KalkanProvider() {
        super(PROVIDER_NAME, 0.1, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                KalkanProvider.this.setup();
                return null;
            }
        });
    }

    public String getName() {
        return super.getName();
    }

    public double getVersion() {
        return super.getVersion();
    }

    private void setup() {
        this.loadAlgorithms(ASYMMETRIC_CIPHER_PACKAGE, ASYMMETRIC_CIPHERS);
        this.put("X509Store.CERTIFICATE/COLLECTION", "kz.gov.pki.kalkan.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "kz.gov.pki.kalkan.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "kz.gov.pki.kalkan.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "kz.gov.pki.kalkan.jce.provider.X509StoreCertPairCollection");
        this.put("X509StreamParser.CERTIFICATE", "kz.gov.pki.kalkan.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "kz.gov.pki.kalkan.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "kz.gov.pki.kalkan.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "kz.gov.pki.kalkan.jce.provider.X509CertPairParser");
        this.put("KeyStore.PKCS12", "kz.gov.pki.kalkan.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        this.put("KeyStore.BCPKCS12", "kz.gov.pki.kalkan.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        this.put("KeyStore.PKCS12-DEF", "kz.gov.pki.kalkan.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore");
        this.put("KeyStore.PKCS12-3DES-40RC2", "kz.gov.pki.kalkan.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        this.put("KeyStore.PKCS12-3DES-3DES", "kz.gov.pki.kalkan.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore3DES");
        this.put("KeyStore.PKCS12-DEF-3DES-40RC2", "kz.gov.pki.kalkan.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore");
        this.put("KeyStore.PKCS12-DEF-3DES-3DES", "kz.gov.pki.kalkan.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore3DES");
        this.put("KeyStore.KalkanFileStore", "kz.gov.pki.kalkan.jce.provider.JDKKalkanFileKeyStore");
        this.put("KeyStore.AKKaztokenStore", "kz.gov.pki.kalkan.pcsc.keystores.AKKaztokenStore");
        this.put("KeyStore.AKKZIDCardStore", "kz.gov.pki.kalkan.pcsc.keystores.AKKZIDCardStore");
        this.put("KeyStore.AKKorganSStore", "kz.gov.pki.kalkan.pcsc.keystores.AKKorganSStore");
        this.put("KeyStore.AKEToken72KStore", "kz.gov.pki.kalkan.pcsc.keystores.AKEToken72KStore");
        this.put("KeyStore.AKJaCartaStore", "kz.gov.pki.kalkan.pcsc.keystores.AKJaCartaStore");
        this.put("KeyStore.JKS", "kz.gov.pki.kalkan.jce.provider.JavaKeyStore$JKS");
        this.put("KeyStore.CaseExactJKS", "kz.gov.pki.kalkan.jce.provider.JavaKeyStore$CaseExactJKS");
        this.put("CertificateFactory.X.509", "kz.gov.pki.kalkan.jce.provider.JDKX509CertificateFactory");
        this.put("Alg.Alias.CertificateFactory.X509", "X.509");
        this.put("AlgorithmParameterGenerator.GOST3410", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameterGenerator$GOST3410");
        this.put("AlgorithmParameterGenerator.DES", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator.DESEDE", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator." + PKCSObjectIdentifiers.des_EDE3_CBC, "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator." + OIWObjectIdentifiers.desCBC, "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator.RC2", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameterGenerator$RC2");
        this.put("AlgorithmParameterGenerator.1.2.840.113549.3.2", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameterGenerator$RC2");
        this.put("Alg.Alias.AlgorithmParameterGenerator.GOST-3410", "GOST3410");
        this.put("AlgorithmParameters.DSA", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$DSA");
        this.put("AlgorithmParameters.PKCS12PBE", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$PKCS12PBE");
        this.put("AlgorithmParameters." + PKCSObjectIdentifiers.des_EDE3_CBC, "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("AlgorithmParameters." + PKCSObjectIdentifiers.id_PBKDF2, "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$PBKDF2");
        this.put("AlgorithmParameters.GOST3410", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$GOST3410");
        this.put("Alg.Alias.AlgorithmParameters.GOST-3410", "GOST3410");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES3KEY-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES2KEY-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.1", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.3", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.5", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.6", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Cipher.DES", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$DES");
        this.put("Cipher.DESEDE", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$DESede");
        this.put("Cipher." + PKCSObjectIdentifiers.des_EDE3_CBC, "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$DESedeCBC");
        this.put("Cipher." + OIWObjectIdentifiers.desCBC, "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$DESCBC");
        this.put("Cipher.DESEDEWRAP", "kz.gov.pki.kalkan.jce.provider.WrapCipherSpi$DESEDEWrap");
        this.put("Cipher." + PKCSObjectIdentifiers.id_alg_CMS3DESwrap, "kz.gov.pki.kalkan.jce.provider.WrapCipherSpi$DESEDEWrap");
        this.put("Cipher.RC2", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$RC2");
        this.put("Cipher.RC2WRAP", "kz.gov.pki.kalkan.jce.provider.WrapCipherSpi$RC2Wrap");
        this.put("Cipher.1.2.840.113549.1.9.16.3.7", "kz.gov.pki.kalkan.jce.provider.WrapCipherSpi$RC2Wrap");
        this.put("Cipher.ARC4", "kz.gov.pki.kalkan.jce.provider.JCEStreamCipher$RC4");
        this.put("Alg.Alias.Cipher.1.2.840.113549.3.4", "ARC4");
        this.put("Alg.Alias.Cipher.ARCFOUR", "ARC4");
        this.put("Alg.Alias.Cipher.RC4", "ARC4");
        this.put("Cipher.RC5", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$RC5");
        this.put("Cipher.1.2.840.113549.3.2", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$RC2CBC");
        this.put("Alg.Alias.Cipher.RC5-32", "RC5");
        this.put("Cipher.RC5-64", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$RC564");
        this.put("Cipher.RC6", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$RC6");
        this.put("Cipher.DESEDERFC3211WRAP", "kz.gov.pki.kalkan.jce.provider.WrapCipherSpi$RFC3211DESedeWrap");
        this.put("Alg.Alias.Cipher.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Cipher.GOST28147", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$GOST28147");
        this.put("Alg.Alias.Cipher.GOST", "GOST28147");
        this.put("Alg.Alias.Cipher.GOST-28147", "GOST28147");
        this.put("Cipher." + CryptoProObjectIdentifiers.gostR28147_cbc, "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$GOST28147cbc");
        this.put("Cipher.RSA", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$NoPadding");
        this.put("Cipher.RSA/RAW", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$NoPadding");
        this.put("Cipher.RSA/PKCS1", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        this.put("Cipher.1.2.840.113549.1.1.1", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        this.put("Cipher.2.5.8.1.1", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        this.put("Cipher.RSA/1", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$PKCS1v1_5Padding_PrivateOnly");
        this.put("Cipher.RSA/2", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$PKCS1v1_5Padding_PublicOnly");
        this.put("Cipher.RSA/OAEP", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$OAEPPadding");
        this.put("Cipher." + PKCSObjectIdentifiers.id_RSAES_OAEP, "kz.gov.pki.kalkan.jce.provider.JCERSACipher$OAEPPadding");
        this.put("Cipher.RSA/ISO9796-1", "kz.gov.pki.kalkan.jce.provider.JCERSACipher$ISO9796d1Padding");
        this.put("Alg.Alias.Cipher.RSA//RAW", "RSA");
        this.put("Alg.Alias.Cipher.RSA//NOPADDING", "RSA");
        this.put("Alg.Alias.Cipher.RSA//PKCS1PADDING", "RSA/PKCS1");
        this.put("Alg.Alias.Cipher.RSA//OAEPPADDING", "RSA/OAEP");
        this.put("Alg.Alias.Cipher.RSA//ISO9796-1PADDING", "RSA/ISO9796-1");
        this.put("Cipher.PBEWITHMD5ANDDES", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "kz.gov.pki.kalkan.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.PBEWITHMD5ANDRC2", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithMD5AndRC2");
        this.put("Cipher.PBEWITHSHA1ANDDES", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithSHA1AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "kz.gov.pki.kalkan.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.PBEWITHSHA1ANDRC2", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithSHA1AndRC2");
        this.put("Cipher.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithSHAAndDES3Key");
        this.put("Cipher.BROKENPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "kz.gov.pki.kalkan.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHAAndDES3Key");
        this.put("Cipher.OLDPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "kz.gov.pki.kalkan.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndDES3Key");
        this.put("Cipher.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithSHAAndDES2Key");
        this.put("Cipher.BROKENPBEWITHSHAAND2-KEYTRIPLEDES-CBC", "kz.gov.pki.kalkan.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHAAndDES2Key");
        this.put("Cipher.PBEWITHSHAAND128BITRC2-CBC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithSHAAnd128BitRC2");
        this.put("Cipher.PBEWITHSHAAND40BITRC2-CBC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithSHAAnd40BitRC2");
        this.put("Cipher.PBEWITHSHAAND128BITRC4", "kz.gov.pki.kalkan.jce.provider.JCEStreamCipher$PBEWithSHAAnd128BitRC4");
        this.put("Cipher.PBEWITHSHAAND40BITRC4", "kz.gov.pki.kalkan.jce.provider.JCEStreamCipher$PBEWithSHAAnd40BitRC4");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND3-KEYTRIPLEDES-CBC", "Cipher.PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND2-KEYTRIPLEDES-CBC", "Cipher.PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC2-CBC", "Cipher.PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC2-CBC", "Cipher.PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC4", "Cipher.PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC4", "Cipher.PBEWITHSHAAND40BITRC4");
        this.put("Cipher.PBEWITHSHAAND128BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHAAND192BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHAAND256BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHA256AND128BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHA256AND192BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHA256AND256BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.put("Cipher.PBEWITHMD5AND128BITAES-CBC-OPENSSL", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHMD5AND192BITAES-CBC-OPENSSL", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHMD5AND256BITAES-CBC-OPENSSL", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHAANDTWOFISH-CBC", "kz.gov.pki.kalkan.jce.provider.JCEBlockCipher$PBEWithSHAAndTwofish");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "kz.gov.pki.kalkan.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.3", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.4", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1ANDDESEDE", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("KeyGenerator.DES", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$DES");
        this.put("Alg.Alias.KeyGenerator." + OIWObjectIdentifiers.desCBC, "DES");
        this.put("KeyGenerator.DESEDE", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$DESede");
        this.put("KeyGenerator." + PKCSObjectIdentifiers.des_EDE3_CBC, "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$DESede3");
        this.put("KeyGenerator.DESEDEWRAP", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$DESede");
        this.put("KeyGenerator.RC2", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RC2");
        this.put("KeyGenerator.1.2.840.113549.3.2", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RC2");
        this.put("KeyGenerator.RC4", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RC4");
        this.put("Alg.Alias.KeyGenerator.ARC4", "RC4");
        this.put("Alg.Alias.KeyGenerator.1.2.840.113549.3.4", "RC4");
        this.put("KeyGenerator.RC5", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RC5");
        this.put("Alg.Alias.KeyGenerator.RC5-32", "RC5");
        this.put("KeyGenerator.RC5-64", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RC564");
        this.put("KeyGenerator.RC6", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RC6");
        this.put("KeyGenerator.GOST28147", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$GOST28147");
        this.put("Alg.Alias.KeyGenerator.GOST", "GOST28147");
        this.put("Alg.Alias.KeyGenerator.GOST-28147", "GOST28147");
        this.put("Alg.Alias.KeyGenerator." + CryptoProObjectIdentifiers.gostR28147_cbc, "GOST28147");
        this.put("KeyPairGenerator.RSA", "kz.gov.pki.kalkan.jce.provider.JDKKeyPairGenerator$RSA");
        this.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1.1", "RSA");
        this.put("Alg.Alias.KeyPairGenerator." + PKCSObjectIdentifiers.sha1WithRSAEncryption, "RSA");
        this.put("Alg.Alias.KeyPairGenerator." + PKCSObjectIdentifiers.sha256WithRSAEncryption, "RSA");
        this.put("Alg.Alias.KeyPairGenerator.SHA1WITHRSA", "RSA");
        this.put("KeyPairGenerator.GOST3410", "kz.gov.pki.kalkan.jce.provider.JDKKeyPairGenerator$GOST3410");
        this.put("Alg.Alias.KeyPairGenerator.GOST-3410", "GOST3410");
        this.put("Alg.Alias.KeyPairGenerator.GOST-3410-94", "GOST3410");
        this.put("KeyPairGenerator.ECGOST3410", "kz.gov.pki.kalkan.jce.provider.JDKKeyPairGenerator$ECGOST3410");
        this.put("Alg.Alias.KeyPairGenerator.ECGOST-3410", "ECGOST3410");
        this.put("Alg.Alias.KeyPairGenerator.GOST-3410-2001", "ECGOST3410");
        this.put("KeyPairGenerator.ECGOST34310", "kz.gov.pki.kalkan.jce.provider.JDKKeyPairGenerator$ECGOST34310");
        this.put("Alg.Alias.KeyPairGenerator." + KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004, "ECGOST34310");
        this.put("Alg.Alias.KeyPairGenerator." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004, "ECGOST34310");
        this.put("Alg.Alias.KeyPairGenerator.ECGOST-34310", "ECGOST34310");
        this.put("Alg.Alias.KeyPairGenerator.GOST-34310-2004", "ECGOST34310");
        this.put("KeyFactory.RSA", "kz.gov.pki.kalkan.jce.provider.JDKKeyFactory$RSA");
        this.put("KeyFactory.X.509", "kz.gov.pki.kalkan.jce.provider.JDKKeyFactory$X509");
        this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "RSA");
        this.put("KeyFactory.GOST3410", "kz.gov.pki.kalkan.jce.provider.JDKKeyFactory$GOST3410");
        this.put("Alg.Alias.KeyFactory.GOST-3410", "GOST3410");
        this.put("Alg.Alias.KeyFactory.GOST-3410-94", "GOST3410");
        this.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR3410_94, "GOST3410");
        this.put("KeyFactory.ECGOST3410", "kz.gov.pki.kalkan.jce.provider.JDKKeyFactory$ECGOST3410");
        this.put("Alg.Alias.KeyFactory.GOST-3410-2001", "ECGOST3410");
        this.put("Alg.Alias.KeyFactory.ECGOST-3410", "ECGOST3410");
        this.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR3410_2001, "ECGOST3410");
        this.put("KeyFactory.ECGOST34310", "kz.gov.pki.kalkan.jce.provider.JDKKeyFactory$ECGOST3410");
        this.put("Alg.Alias.KeyFactory.GOST-34310-2004", "ECGOST34310");
        this.put("Alg.Alias.KeyFactory.ECGOST-34310", "ECGOST34310");
        this.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR34310_2004, "ECGOST34310");
        this.put("Alg.Alias.KeyFactory." + KNCAObjectIdentifiers.gost34310_2004, "ECGOST34310");
        this.put("AlgorithmParameters.DES", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("Alg.Alias.AlgorithmParameters." + OIWObjectIdentifiers.desCBC, "DES");
        this.put("AlgorithmParameters.DESEDE", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("AlgorithmParameters." + PKCSObjectIdentifiers.des_EDE3_CBC, "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("AlgorithmParameters.RC2", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$RC2AlgorithmParameters");
        this.put("AlgorithmParameters.1.2.840.113549.3.2", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$RC2AlgorithmParameters");
        this.put("AlgorithmParameters.RC5", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("AlgorithmParameters.RC6", "kz.gov.pki.kalkan.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("SecretKeyFactory.DES", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$DES");
        this.put("SecretKeyFactory.DESEDE", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$DESede");
        this.put("SecretKeyFactory.PBEWITHMD2ANDDES", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithMD2AndDES");
        this.put("SecretKeyFactory.PBEWITHMD2ANDRC2", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithMD2AndRC2");
        this.put("SecretKeyFactory.PBEWITHMD5ANDDES", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithMD5AndDES");
        this.put("SecretKeyFactory.PBEWITHMD5ANDRC2", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithMD5AndRC2");
        this.put("SecretKeyFactory.PBEWITHSHA1ANDDES", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHA1AndDES");
        this.put("SecretKeyFactory.PBEWITHSHA1ANDRC2", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHA1AndRC2");
        this.put("SecretKeyFactory.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAndDES3Key");
        this.put("SecretKeyFactory.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAndDES2Key");
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITRC4", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitRC4");
        this.put("SecretKeyFactory.PBEWITHSHAAND40BITRC4", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd40BitRC4");
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITRC2-CBC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitRC2");
        this.put("SecretKeyFactory.PBEWITHSHAAND40BITRC2-CBC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd40BitRC2");
        this.put("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAndTwofish");
        this.put("SecretKeyFactory.PBEWITHHMACRIPEMD160", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithRIPEMD160");
        this.put("SecretKeyFactory.PBEWITHHMACSHA1", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHA");
        this.put("SecretKeyFactory.PBEWITHHMACTIGER", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithTiger");
        this.put("SecretKeyFactory.PBEWITHMD5AND128BITAES-CBC-OPENSSL", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithMD5And128BitAESCBCOpenSSL");
        this.put("SecretKeyFactory.PBEWITHMD5AND192BITAES-CBC-OPENSSL", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithMD5And192BitAESCBCOpenSSL");
        this.put("SecretKeyFactory.PBEWITHMD5AND256BITAES-CBC-OPENSSL", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithMD5And256BitAESCBCOpenSSL");
        this.put("Alg.Alias.SecretKeyFactory.PBE", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHMD5ANDDES", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHA1ANDDES", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAANDTWOFISH-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDDES-CBC", "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDRC2-CBC", "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDDES-CBC", "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDRC2-CBC", "PBEWITHMD5ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDDES-CBC", "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDRC2-CBC", "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.3", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.4", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHHMACSHA", "PBEWITHHMACSHA1");
        this.put("Alg.Alias.SecretKeyFactory.1.3.14.3.2.26", "PBEWITHHMACSHA1");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHAAND192BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd192BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHAAND256BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd256BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHA256AND128BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHA256And128BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHA256AND192BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHA256And192BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHA256AND256BITAES-CBC-BC", "kz.gov.pki.kalkan.jce.provider.JCESecretKeyFactory$PBEWithSHA256And256BitAESBC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.addMacAlgorithms();
        this.addMessageDigestAlgorithms();
        this.addSignatureAlgorithms();
        this.put("CertPathValidator.RFC3281", "kz.gov.pki.kalkan.jce.provider.PKIXAttrCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3281", "kz.gov.pki.kalkan.jce.provider.PKIXAttrCertPathBuilderSpi");
        this.put("CertPathValidator.RFC3280", "kz.gov.pki.kalkan.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3280", "kz.gov.pki.kalkan.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertPathValidator.PKIX", "kz.gov.pki.kalkan.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.PKIX", "kz.gov.pki.kalkan.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertStore.Collection", "kz.gov.pki.kalkan.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "kz.gov.pki.kalkan.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "kz.gov.pki.kalkan.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    private void loadAlgorithms(String packageName, String[] names) {
        for (int i = 0; i != names.length; ++i) {
            Class<?> clazz = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                clazz = loader != null ? loader.loadClass(packageName + names[i] + "Mappings") : Class.forName(packageName + names[i] + "Mappings");
            }
            catch (ClassNotFoundException loader) {
                // empty catch block
            }
            if (clazz == null) continue;
            try {
                this.addMappings((Map)clazz.newInstance());
                continue;
            }
            catch (Exception e) {
                throw new InternalError("cannot create instance of " + packageName + names[i] + "Mappings : " + e);
            }
        }
    }

    private void addMappings(Map mappings) {
        for (Object key : mappings.keySet()) {
            if (this.containsKey(key)) {
                throw new IllegalStateException("duplicate provider key (" + key + ") found in " + mappings.getClass().getName());
            }
            this.put(key, mappings.get(key));
        }
    }

    private void addMacAlgorithms() {
        this.put("Mac.DESMAC", "kz.gov.pki.kalkan.jce.provider.JCEMac$DES");
        this.put("Alg.Alias.Mac.DES", "DESMAC");
        this.put("Mac.DESMAC/CFB8", "kz.gov.pki.kalkan.jce.provider.JCEMac$DESCFB8");
        this.put("Alg.Alias.Mac.DES/CFB8", "DESMAC/CFB8");
        this.put("Mac.DESEDEMAC", "kz.gov.pki.kalkan.jce.provider.JCEMac$DESede");
        this.put("Alg.Alias.Mac.DESEDE", "DESEDEMAC");
        this.put("Mac.DESEDEMAC/CFB8", "kz.gov.pki.kalkan.jce.provider.JCEMac$DESedeCFB8");
        this.put("Alg.Alias.Mac.DESEDE/CFB8", "DESEDEMAC/CFB8");
        this.put("Mac.DESWITHISO9797", "kz.gov.pki.kalkan.jce.provider.JCEMac$DES9797Alg3");
        this.put("Alg.Alias.Mac.DESISO9797MAC", "DESWITHISO9797");
        this.put("Mac.DESEDEMAC64", "kz.gov.pki.kalkan.jce.provider.JCEMac$DESede64");
        this.put("Alg.Alias.Mac.DESEDE64", "DESEDEMAC64");
        this.put("Mac.DESEDEMAC64WITHISO7816-4PADDING", "kz.gov.pki.kalkan.jce.provider.JCEMac$DESede64with7816d4");
        this.put("Alg.Alias.Mac.DESEDE64WITHISO7816-4PADDING", "DESEDEMAC64WITHISO7816-4PADDING");
        this.put("Alg.Alias.Mac.DESEDEISO9797ALG1MACWITHISO7816-4PADDING", "DESEDEMAC64WITHISO7816-4PADDING");
        this.put("Alg.Alias.Mac.DESEDEISO9797ALG1WITHISO7816-4PADDING", "DESEDEMAC64WITHISO7816-4PADDING");
        this.put("Mac.ISO9797ALG3MAC", "kz.gov.pki.kalkan.jce.provider.JCEMac$DES9797Alg3");
        this.put("Alg.Alias.Mac.ISO9797ALG3", "ISO9797ALG3MAC");
        this.put("Mac.ISO9797ALG3WITHISO7816-4PADDING", "kz.gov.pki.kalkan.jce.provider.JCEMac$DES9797Alg3with7816d4");
        this.put("Alg.Alias.Mac.ISO9797ALG3MACWITHISO7816-4PADDING", "ISO9797ALG3WITHISO7816-4PADDING");
        this.put("Mac.SKIPJACKMAC", "kz.gov.pki.kalkan.jce.provider.JCEMac$Skipjack");
        this.put("Alg.Alias.Mac.SKIPJACK", "SKIPJACKMAC");
        this.put("Mac.SKIPJACKMAC/CFB8", "kz.gov.pki.kalkan.jce.provider.JCEMac$SkipjackCFB8");
        this.put("Alg.Alias.Mac.SKIPJACK/CFB8", "SKIPJACKMAC/CFB8");
        this.put("Mac.RC2MAC", "kz.gov.pki.kalkan.jce.provider.JCEMac$RC2");
        this.put("Alg.Alias.Mac.RC2", "RC2MAC");
        this.put("Mac.RC2MAC/CFB8", "kz.gov.pki.kalkan.jce.provider.JCEMac$RC2CFB8");
        this.put("Alg.Alias.Mac.RC2/CFB8", "RC2MAC/CFB8");
        this.put("Mac.RC5MAC", "kz.gov.pki.kalkan.jce.provider.JCEMac$RC5");
        this.put("Alg.Alias.Mac.RC5", "RC5MAC");
        this.put("Mac.RC5MAC/CFB8", "kz.gov.pki.kalkan.jce.provider.JCEMac$RC5CFB8");
        this.put("Alg.Alias.Mac.RC5/CFB8", "RC5MAC/CFB8");
        this.put("Mac.GOST28147MAC", "kz.gov.pki.kalkan.jce.provider.JCEMac$GOST28147");
        this.put("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        this.put("Mac.OLDHMACSHA384", "kz.gov.pki.kalkan.jce.provider.JCEMac$OldSHA384");
        this.put("Mac.OLDHMACSHA512", "kz.gov.pki.kalkan.jce.provider.JCEMac$OldSHA512");
        this.addHMACAlgorithm("MD2", "kz.gov.pki.kalkan.jce.provider.JCEMac$MD2", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$MD2HMAC");
        this.addHMACAlgorithm("MD4", "kz.gov.pki.kalkan.jce.provider.JCEMac$MD4", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$MD4HMAC");
        this.addHMACAlgorithm("MD5", "kz.gov.pki.kalkan.jce.provider.JCEMac$MD5", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$MD5HMAC");
        this.addHMACAlgorithm("SHA1", "kz.gov.pki.kalkan.jce.provider.JCEMac$SHA1", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$HMACSHA1");
        this.addHMACAlias("SHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        this.addHMACAlgorithm("SHA224", "kz.gov.pki.kalkan.jce.provider.JCEMac$SHA224", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$HMACSHA224");
        this.addHMACAlias("SHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        this.addHMACAlgorithm("SHA256", "kz.gov.pki.kalkan.jce.provider.JCEMac$SHA256", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$HMACSHA256");
        this.addHMACAlias("SHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        this.addHMACAlgorithm("SHA384", "kz.gov.pki.kalkan.jce.provider.JCEMac$SHA384", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$HMACSHA384");
        this.addHMACAlias("SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        this.addHMACAlgorithm("SHA512", "kz.gov.pki.kalkan.jce.provider.JCEMac$SHA512", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$HMACSHA512");
        this.addHMACAlias("SHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        this.addHMACAlgorithm("RIPEMD128", "kz.gov.pki.kalkan.jce.provider.JCEMac$RIPEMD128", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RIPEMD128HMAC");
        this.addHMACAlgorithm("RIPEMD160", "kz.gov.pki.kalkan.jce.provider.JCEMac$RIPEMD160", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$RIPEMD160HMAC");
        this.addHMACAlgorithm("TIGER", "kz.gov.pki.kalkan.jce.provider.JCEMac$Tiger", "kz.gov.pki.kalkan.jce.provider.JCEKeyGenerator$HMACTIGER");
        this.put("Mac.PBEWITHHMACSHA", "kz.gov.pki.kalkan.jce.provider.JCEMac$PBEWithSHA");
        this.put("Mac.PBEWITHHMACSHA1", "kz.gov.pki.kalkan.jce.provider.JCEMac$PBEWithSHA");
        this.put("Mac.PBEWITHHMACRIPEMD160", "kz.gov.pki.kalkan.jce.provider.JCEMac$PBEWithRIPEMD160");
        this.put("Alg.Alias.Mac.1.3.14.3.2.26", "PBEWITHHMACSHA");
    }

    private void addHMACAlgorithm(String algorithm, String algorithmClassName, String keyGeneratorClassName) {
        String mainName = "HMAC" + algorithm;
        this.put("Mac." + mainName, algorithmClassName);
        this.put("Alg.Alias.Mac.HMAC-" + algorithm, mainName);
        this.put("Alg.Alias.Mac.HMAC/" + algorithm, mainName);
        this.put("KeyGenerator." + mainName, keyGeneratorClassName);
        this.put("Alg.Alias.KeyGenerator.HMAC-" + algorithm, mainName);
        this.put("Alg.Alias.KeyGenerator.HMAC/" + algorithm, mainName);
    }

    private void addHMACAlias(String algorithm, DERObjectIdentifier oid) {
        String mainName = "HMAC" + algorithm;
        this.put("Alg.Alias.Mac." + oid, mainName);
        this.put("Alg.Alias.KeyGenerator." + oid, mainName);
    }

    private void addMessageDigestAlgorithms() {
        this.put("MessageDigest.SHA-1", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$SHA1");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        this.put("Alg.Alias.MessageDigest.SHA", "SHA-1");
        this.put("Alg.Alias.MessageDigest." + OIWObjectIdentifiers.idSHA1, "SHA-1");
        this.put("MessageDigest.SHA-224", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$SHA224");
        this.put("Alg.Alias.MessageDigest.SHA224", "SHA-224");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha224, "SHA-224");
        this.put("MessageDigest.SHA-256", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$SHA256");
        this.put("Alg.Alias.MessageDigest.SHA256", "SHA-256");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha256, "SHA-256");
        this.put("MessageDigest.SHA-384", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$SHA384");
        this.put("Alg.Alias.MessageDigest.SHA384", "SHA-384");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
        this.put("MessageDigest.SHA-512", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$SHA512");
        this.put("Alg.Alias.MessageDigest.SHA512", "SHA-512");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha512, "SHA-512");
        this.put("MessageDigest.MD2", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$MD2");
        this.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md2, "MD2");
        this.put("MessageDigest.MD4", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$MD4");
        this.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
        this.put("MessageDigest.MD5", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$MD5");
        this.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md5, "MD5");
        this.put("MessageDigest.GOST3411", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$GOST3411");
        this.put("Alg.Alias.MessageDigest.GOST", "GOST3411");
        this.put("Alg.Alias.MessageDigest.GOST-3411", "GOST3411");
        this.put("Alg.Alias.MessageDigest.gost34311", "GOST3411");
        this.put("Alg.Alias.MessageDigest.1.3.6.1.4.1.6801.1.2.1", "GOST3411");
        this.put("Alg.Alias.MessageDigest." + KNCAObjectIdentifiers.gost34311_95, "GOST3411");
        this.put("MessageDigest.GOSTR341194", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$GOSTR341194");
        this.put("Alg.Alias.MessageDigest." + CryptoProObjectIdentifiers.gostR3411, "GOSTR341194");
        this.put("MessageDigest.KNCANULL", "kz.gov.pki.kalkan.jce.provider.JDKMessageDigest$NULL");
        this.put("Alg.Alias.MessageDigest.1.2.398.3.10.1.3", "KNCANULL");
    }

    private void addSignatureAlgorithms() {
        this.put("Signature.MD2WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$MD2WithRSAEncryption");
        this.put("Signature.MD4WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$MD4WithRSAEncryption");
        this.put("Signature.MD5WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$MD5WithRSAEncryption");
        this.put("Signature.SHA1WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$SHA1WithRSAEncryption");
        this.put("Signature.SHA224WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$SHA224WithRSAEncryption");
        this.put("Signature.SHA256WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$SHA256WithRSAEncryption");
        this.put("Signature.SHA384WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$SHA384WithRSAEncryption");
        this.put("Signature.SHA512WithRSAEncryption", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$SHA512WithRSAEncryption");
        this.put("Signature.SHA1withRSA/ISO9796-2", "kz.gov.pki.kalkan.jce.provider.JDKISOSignature$SHA1WithRSAEncryption");
        this.put("Signature.MD5withRSA/ISO9796-2", "kz.gov.pki.kalkan.jce.provider.JDKISOSignature$MD5WithRSAEncryption");
        this.put("Signature.RSA", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$SHA1WithRSAEncryption");
        this.put("Signature.RAWRSA", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$noneRSA");
        this.put("Alg.Alias.Signature.NONEWITHRSA", "RAWRSA");
        this.put("Signature.RAWRSA256", "kz.gov.pki.kalkan.jce.provider.JDKDigestSignature$noneRSA256");
        this.put("Alg.Alias.Signature.NONEWITHRSA256", "RAWRSA256");
        this.put("Alg.Alias.Signature.MD2withRSAEncryption", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4withRSAEncryption", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5withRSAEncryption", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1withRSAEncryption", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224withRSAEncryption", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256withRSAEncryption", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384withRSAEncryption", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512withRSAEncryption", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WithRSAEncryption", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WithRSAEncryption", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WithRSAEncryption", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WITHRSAENCRYPTION", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WITHRSAENCRYPTION", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WITHRSAENCRYPTION", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md2WithRSAEncryption, "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2WithRSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2withRSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2/RSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WithRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5withRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5/RSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4WithRSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4withRSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4/RSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md4WithRSAEncryption, "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WithRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1withRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224WithRSA", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224withRSA", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WithRSA", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256withRSA", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WithRSA", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384withRSA", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WithRSA", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512withRSA", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1/RSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA-1/RSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.1", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.5", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.2.840.113549.2.5with1.2.840.113549.1.1.1", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature." + OIWObjectIdentifiers.sha1WithRSA, "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2WITHRSAENCRYPTION", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WITHRSAENCRYPTION", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WITHRSAENCRYPTION", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WITHRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WITHRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WithRSA/ISO9796-2", "MD5withRSA/ISO9796-2");
        this.put("Alg.Alias.Signature.SHA1WithRSA/ISO9796-2", "SHA1withRSA/ISO9796-2");
        this.put("Alg.Alias.Signature.RIPEMD160WithRSA/ISO9796-2", "RIPEMD160withRSA/ISO9796-2");
        this.put("Signature.ECGOST3410", "kz.gov.pki.kalkan.jce.provider.JDKGOST3410Signer$ecgost3410");
        this.put("Alg.Alias.Signature.ECGOST-3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST-3410-2001", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411withECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411WITHECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411WithECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.1.3.6.1.4.1.6801.1.2.1with1.3.6.1.4.1.6801.1.2.2", "ECGOST3410");
        this.put("Alg.Alias.Signature." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "ECGOST3410");
        this.put("Signature.ECGOST34310", "kz.gov.pki.kalkan.jce.provider.JDKGOST3410Signer$ecgost3410");
        this.put("Alg.Alias.Signature.ECGOST-34310", "ECGOST34310");
        this.put("Alg.Alias.Signature.GOST-34310-2004", "ECGOST34310");
        this.put("Alg.Alias.Signature.GOST3411withECGOST34310", "ECGOST34310");
        this.put("Alg.Alias.Signature.GOST34311withECGOST34310", "ECGOST34310");
        this.put("Alg.Alias.Signature.GOST3411WITHECGOST34310", "ECGOST34310");
        this.put("Alg.Alias.Signature.GOST3411WithECGOST34310", "ECGOST34310");
        this.put("Alg.Alias.Signature." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004, "ECGOST34310");
        this.put("Alg.Alias.Signature.1.3.6.1.4.1.6801.1.2.1with1.3.6.1.4.1.6801.1.5.8", "ECGOST34310");
        this.put("Alg.Alias.Signature." + KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004, "ECGOST34310");
        this.put("Alg.Alias.Signature." + KNCAObjectIdentifiers.gost34311_95 + "with" + KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004, "ECGOST34310");
        this.put("Alg.Alias.Signature." + KNCAObjectIdentifiers.gost34311_95 + "with" + KNCAObjectIdentifiers.gost34310_2004, "ECGOST34310");
        this.put("Signature.GOST3410", "kz.gov.pki.kalkan.jce.provider.JDKGOST3410Signer$gost3410");
        this.put("Alg.Alias.Signature.GOST-3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST-3410-94", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411withGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411WITHGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411WithGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3410");
        this.put("Signature.RAWECGOST34310", "kz.gov.pki.kalkan.jce.provider.JDKGOST3410Signer$noneECGOST34310");
        this.put("Alg.Alias.Signature.NONEWITHECGOST34310", "RAWECGOST34310");
        String pkgDSA = "kz.gov.pki.kalkan.jce.provider.asymmetric.dsa.";
        this.addSignatureAlgorithm("SHA1", "DSA", pkgDSA + "DSASigner$stdDSA", X9ObjectIdentifiers.id_dsa_with_sha1);
        this.addSignatureAlgorithm("SHA256", "DSA", pkgDSA + "DSASigner$dsa256", NISTObjectIdentifiers.dsa_with_sha256);
    }

    private void addSignatureAlgorithm(String digest, String algorithm, String className, DERObjectIdentifier oid) {
        String mainName = digest + "WITH" + algorithm;
        String jdk11Variation1 = digest + "with" + algorithm;
        String jdk11Variation2 = digest + "With" + algorithm;
        String alias = digest + "/" + algorithm;
        this.put("Signature." + mainName, className);
        this.put("Alg.Alias.Signature." + jdk11Variation1, mainName);
        this.put("Alg.Alias.Signature." + jdk11Variation2, mainName);
        this.put("Alg.Alias.Signature." + alias, mainName);
        this.put("Alg.Alias.Signature." + oid, mainName);
        this.put("Alg.Alias.Signature.OID." + oid, mainName);
    }

    public void setParameter(String parameterName, Object parameter) {
        ProviderUtil.setParameter(parameterName, parameter);
    }
}

