/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PrivateKeyInfo;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.jce.interfaces.PKCS12BagAttributeCarrier;
import kz.gov.pki.kalkan.jce.provider.JCEECPrivateKey;
import kz.gov.pki.kalkan.jce.provider.JCERSAPrivateCrtKey;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.jce.provider.util.TumarBinStoreUtils;
import kz.gov.pki.kalkan.util.ByteUtils;
import kz.gov.pki.kalkan.util.encoders.Hex;

public class TumarBinStore {
    private ASN1Sequence body = null;

    public TumarBinStore(byte[] binputBytes) {
        try {
            this.body = (ASN1Sequence)ASN1Sequence.fromByteArray(binputBytes);
        }
        catch (IOException ex) {
            System.err.println("Wrong ASN1Sequence in bin format");
            ex.printStackTrace();
        }
    }

    public String getKeyPairIdList() throws IOException, CertificateException {
        StringBuilder sb = new StringBuilder();
        TumarBinStoreUtils tbsu = new TumarBinStoreUtils();
        if (this.body != null) {
            ASN1Sequence keyPairSequence = (ASN1Sequence)this.body.getObjectAt(1);
            for (int index = 0; index < keyPairSequence.size(); ++index) {
                ASN1Sequence keyPair = (ASN1Sequence)keyPairSequence.getObjectAt(index);
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)keyPair.getObjectAt(1);
                X509Certificate x509Certificate = this.getX509Certificate(index);
                if (x509Certificate != null) {
                    if (dERObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR34310_2004) || dERObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
                        sb.append("GOST|");
                    } else {
                        sb.append("RSA|");
                    }
                    sb.append(Hex.encodeStr(((ASN1OctetString)keyPair.getObjectAt(6)).getOctets()));
                    sb.append("|");
                    sb.append(x509Certificate.getSerialNumber().toString(16));
                    sb.append(x509Certificate.getSubjectDN().getName());
                    sb.append("|");
                    sb.append(tbsu.parseDateToString(x509Certificate.getNotBefore()));
                    sb.append("|");
                    tbsu.containsDigitalSignatureUsage(x509Certificate);
                    sb.append(tbsu.parseDateToString(x509Certificate.getNotAfter()));
                    if (index == keyPairSequence.size() - 1) continue;
                    sb.append("\n");
                    continue;
                }
                sb.append("PRIVATE KEY WITH NO CERTIFICATE");
                sb.append("|");
                sb.append(Hex.encodeStr(((ASN1OctetString)keyPair.getObjectAt(6)).getOctets()));
                sb.append("\n");
            }
        } else {
            System.err.println("Bin Body is null");
            return null;
        }
        return sb.toString();
    }

    public ASN1Sequence getKeyPairSequence() {
        if (this.body != null) {
            return (ASN1Sequence)this.body.getObjectAt(1);
        }
        System.err.println("Bin Body is null");
        return null;
    }

    public ASN1Sequence getKeyPairAtIndex(int index) {
        if (this.body != null) {
            ASN1Sequence keyPaisSequence = (ASN1Sequence)this.body.getObjectAt(1);
            if (index < 0 || index >= keyPaisSequence.size()) {
                System.err.println("Bin Body is null");
                return null;
            }
            return (ASN1Sequence)keyPaisSequence.getObjectAt(index);
        }
        System.err.println("Bin Body is null");
        return null;
    }

    public PrivateKey getPrivateKey(String keyIdentifier) throws FileNotFoundException, IOException {
        PrivateKey privateKey = null;
        if (this.body != null) {
            ASN1Sequence keyPairSequence = (ASN1Sequence)this.body.getObjectAt(1);
            for (int index = 0; index < keyPairSequence.size(); ++index) {
                ASN1Sequence keyPair = (ASN1Sequence)keyPairSequence.getObjectAt(index);
                String checkId = Hex.encodeStr(((ASN1OctetString)keyPair.getObjectAt(6)).getOctets());
                if (!checkId.equalsIgnoreCase(keyIdentifier)) continue;
                privateKey = this.getPrivateKey(index);
                break;
            }
        } else {
            System.err.println("Tumar BINSTORE Body is null");
        }
        return privateKey;
    }

    public X509Certificate getX509Certificate(String keyIdentifier) throws FileNotFoundException, IOException, CertificateException {
        X509Certificate x509Certificate = null;
        if (this.body != null) {
            ASN1Sequence keyPairSequence = (ASN1Sequence)this.body.getObjectAt(1);
            for (int index = 0; index < keyPairSequence.size(); ++index) {
                ASN1Sequence keyPair = (ASN1Sequence)keyPairSequence.getObjectAt(index);
                String checkId = Hex.encodeStr(((ASN1OctetString)keyPair.getObjectAt(6)).getOctets());
                if (!checkId.equalsIgnoreCase(keyIdentifier)) continue;
                x509Certificate = this.getX509Certificate(index);
                break;
            }
        } else {
            System.err.println("Tumar BINSTORE Body is null");
        }
        return x509Certificate;
    }

    public PrivateKey getPrivateKey(int index) throws FileNotFoundException, IOException {
        PKCS12BagAttributeCarrier privateKey = null;
        if (this.body != null) {
            ASN1Sequence keyPairSequence = (ASN1Sequence)this.body.getObjectAt(1);
            if (index < 0 || index >= keyPairSequence.size()) {
                System.err.println("Bin Body is null");
                return null;
            }
            ASN1Sequence keyPair = (ASN1Sequence)keyPairSequence.getObjectAt(index);
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)keyPair.getObjectAt(1);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(dERObjectIdentifier, new DERNull());
            if (dERObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR34310_2004) || dERObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
                ASN1OctetString privateKeyOctetString = (ASN1OctetString)keyPair.getObjectAt(4);
                byte[] reversedOctetBytes = ByteUtils.inverseCopyByte(privateKeyOctetString.getOctets(), 0, privateKeyOctetString.getOctets().length);
                DERInteger pkVersion = new DERInteger(1);
                DEROctetString pkOctetString = new DEROctetString(reversedOctetBytes);
                ASN1Encodable[] pkArray = new ASN1Encodable[]{pkVersion, pkOctetString};
                DERSequence aSN1Sequence = new DERSequence(pkArray);
                PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, aSN1Sequence);
                privateKey = new JCEECPrivateKey(pki);
            } else {
                dERObjectIdentifier = new DERObjectIdentifier(PKCSObjectIdentifiers.rsaEncryption.getId());
                DEROctetString octetString = (DEROctetString)keyPair.getObjectAt(4);
                ASN1Sequence privateKeySequence = (ASN1Sequence)ASN1Sequence.fromByteArray(octetString.getOctets());
                PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, privateKeySequence);
                privateKey = new JCERSAPrivateCrtKey(pki);
            }
        } else {
            System.err.println("Tumar BINSTORE Body is null");
        }
        return privateKey;
    }

    public X509Certificate getX509Certificate(int index) throws IOException, CertificateException {
        X509Certificate x509Certificate = null;
        if (this.body != null) {
            ASN1Sequence keyPairSequence = (ASN1Sequence)this.body.getObjectAt(1);
            if (index < 0 || index >= keyPairSequence.size()) {
                System.err.println("Bin Body is null");
                return null;
            }
            ASN1Sequence keyPair = (ASN1Sequence)keyPairSequence.getObjectAt(index);
            try {
                if (keyPair.getObjectAt(8) == null || keyPair.size() < 8) {
                    System.err.println("Certificate not found");
                    return null;
                }
                DERTaggedObject dERTaggedObject = (DERTaggedObject)keyPair.getObjectAt(8);
                ASN1OctetString aSN1OctetString = (ASN1OctetString)dERTaggedObject.getObject();
                ByteArrayInputStream stream = new ByteArrayInputStream(aSN1OctetString.getOctets());
                CertificateFactory cf = CertificateFactory.getInstance("X.509", new KalkanProvider());
                x509Certificate = (X509Certificate)cf.generateCertificate(stream);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                System.err.println("Certificate for current private key is not found");
                return null;
            }
        } else {
            System.err.println("Tumar BINSTORE Body is null");
        }
        return x509Certificate;
    }
}

