/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.asymmetric.dsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.crypto.CipherParameters;
import kz.gov.pki.kalkan.crypto.DSA;
import kz.gov.pki.kalkan.crypto.Digest;
import kz.gov.pki.kalkan.crypto.digests.NullDigest;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA224Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA256Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA384Digest;
import kz.gov.pki.kalkan.crypto.digests.SHA512Digest;
import kz.gov.pki.kalkan.crypto.params.AsymmetricKeyParameter;
import kz.gov.pki.kalkan.crypto.params.ParametersWithRandom;
import kz.gov.pki.kalkan.jce.provider.asymmetric.dsa.BCDSAPublicKey;
import kz.gov.pki.kalkan.jce.provider.asymmetric.dsa.DSAUtil;

public class DSASigner
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer;
    private SecureRandom random;

    protected DSASigner(Digest digest, DSA signer) {
        this.digest = digest;
        this.signer = signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        if (publicKey instanceof DSAKey) {
            param = DSAUtil.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = new BCDSAPublicKey(SubjectPublicKeyInfo.getInstance(bytes));
                if (!(publicKey instanceof DSAKey)) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                param = DSAUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception e) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        this.digest.reset();
        this.signer.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters param = DSAUtil.generatePrivateKeyParameter(privateKey);
        if (this.random != null) {
            param = new ParametersWithRandom(param, this.random);
        }
        this.digest.reset();
        this.signer.init(true, param);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            BigInteger[] sig = this.signer.generateSignature(hash);
            return this.derEncode(sig[0], sig[1]);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sig = this.derDecode(sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(hash, sig[0], sig[1]);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1Encodable[] rs = new DERInteger[]{new DERInteger(r), new DERInteger(s)};
        return new DERSequence(rs).getEncoded();
    }

    private BigInteger[] derDecode(byte[] encoding) throws IOException {
        ASN1Sequence s = (ASN1Sequence)ASN1Object.fromByteArray(encoding);
        return new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
    }

    public static class noneDSA
    extends DSASigner {
        public noneDSA() {
            super(new NullDigest(), new kz.gov.pki.kalkan.crypto.signers.DSASigner());
        }
    }

    public static class dsa512
    extends DSASigner {
        public dsa512() {
            super(new SHA512Digest(), new kz.gov.pki.kalkan.crypto.signers.DSASigner());
        }
    }

    public static class dsa384
    extends DSASigner {
        public dsa384() {
            super(new SHA384Digest(), new kz.gov.pki.kalkan.crypto.signers.DSASigner());
        }
    }

    public static class dsa256
    extends DSASigner {
        public dsa256() {
            super(new SHA256Digest(), new kz.gov.pki.kalkan.crypto.signers.DSASigner());
        }
    }

    public static class dsa224
    extends DSASigner {
        public dsa224() {
            super(new SHA224Digest(), new kz.gov.pki.kalkan.crypto.signers.DSASigner());
        }
    }

    public static class stdDSA
    extends DSASigner {
        public stdDSA() {
            super(new SHA1Digest(), new kz.gov.pki.kalkan.crypto.signers.DSASigner());
        }
    }
}

