/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.BEROctetStringGenerator;
import kz.gov.pki.kalkan.asn1.BERSequenceGenerator;
import kz.gov.pki.kalkan.asn1.BERSet;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.CMSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.jce.provider.cms.CMSEnvelopedGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.CMSEnvelopedHelper;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;

public class CMSEnvelopedDataStreamGenerator
extends CMSEnvelopedGenerator {
    private Object _originatorInfo = null;
    private Object _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean berEncodeRecipientSet) {
        this._berEncodeRecipientSet = berEncodeRecipientSet;
    }

    private DERInteger getVersion() {
        if (this._originatorInfo != null || this._unprotectedAttributes != null) {
            return new DERInteger(2);
        }
        return new DERInteger(0);
    }

    private OutputStream open(OutputStream out, String encryptionOID, KeyGenerator keyGen, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        String encProvider = keyGen.getProvider().getName();
        SecretKey encKey = keyGen.generateKey();
        AlgorithmParameters params = this.generateParameters(encryptionOID, encKey, encProvider);
        Iterator it = this.recipientInfs.iterator();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        while (it.hasNext()) {
            CMSEnvelopedGenerator.RecipientInf recipient = (CMSEnvelopedGenerator.RecipientInf)it.next();
            try {
                recipientInfos.add(recipient.toRecipientInfo(encKey, provider));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for algorithm.", e);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("error making encrypted content.", e);
            }
        }
        return this.open(out, encryptionOID, encKey, params, recipientInfos, encProvider);
    }

    protected OutputStream open(OutputStream out, String encryptionOID, SecretKey encKey, AlgorithmParameters params, ASN1EncodableVector recipientInfos, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        try {
            BERSequenceGenerator cGen = new BERSequenceGenerator(out);
            cGen.addObject(CMSObjectIdentifiers.envelopedData);
            BERSequenceGenerator envGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
            envGen.addObject(this.getVersion());
            if (this._berEncodeRecipientSet) {
                envGen.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
            } else {
                envGen.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
            }
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(encryptionOID, provider);
            cipher.init(1, (Key)encKey, params);
            BERSequenceGenerator eiGen = new BERSequenceGenerator(envGen.getRawOutputStream());
            eiGen.addObject(PKCSObjectIdentifiers.data);
            if (params == null) {
                params = cipher.getParameters();
            }
            AlgorithmIdentifier encAlgId = this.getAlgorithmIdentifier(encryptionOID, params);
            eiGen.getRawOutputStream().write(encAlgId.getEncoded());
            BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, false);
            CipherOutputStream cOut = this._bufferSize != 0 ? new CipherOutputStream(octGen.getOctetOutputStream(new byte[this._bufferSize]), cipher) : new CipherOutputStream(octGen.getOctetOutputStream(), cipher);
            return new CmsEnvelopedDataOutputStream(cOut, cGen, envGen, eiGen);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", e);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
    }

    public OutputStream open(OutputStream out, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        try {
            KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
            return this.open(out, encryptionOID, keyGen, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find key generation algorithm.", e);
        }
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        try {
            KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
            keyGen.init(keySize);
            return this.open(out, encryptionOID, keyGen, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find key generation algorithm.", e);
        }
    }

    private class CmsEnvelopedDataOutputStream
    extends OutputStream {
        private CipherOutputStream _out;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _envGen;
        private BERSequenceGenerator _eiGen;

        public CmsEnvelopedDataOutputStream(CipherOutputStream out, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._cGen = cGen;
            this._envGen = envGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._envGen.close();
            this._cGen.close();
        }
    }
}

