/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1OutputStream;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.BERSequence;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.ContentInfo;
import kz.gov.pki.kalkan.asn1.cms.SignedData;
import kz.gov.pki.kalkan.asn1.cms.SignerInfo;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedHelper;
import kz.gov.pki.kalkan.jce.provider.cms.CMSUtils;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformationStore;
import kz.gov.pki.kalkan.x509.NoSuchStoreException;
import kz.gov.pki.kalkan.x509.X509Store;

public class CMSSignedData {
    private static CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSProcessable signedContent = null;
    CertStore certStore;
    SignerInformationStore signerInfoStore;
    X509Store attributeStore;
    X509Store certificateStore;
    X509Store crlStore;
    byte[] rawDigest = null;

    private CMSSignedData(CMSSignedData c) {
        this.signedData = c.signedData;
        this.contentInfo = c.contentInfo;
        this.signedContent = c.signedContent;
        this.certStore = c.certStore;
        this.signerInfoStore = c.signerInfoStore;
    }

    public CMSSignedData(byte[] sigBlock) throws CMSException {
        this(CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, byte[] sigBlock) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(byte[] hashedData, byte[] sigBlock) throws CMSException {
        this.rawDigest = hashedData;
        this.contentInfo = CMSUtils.readContentInfo(sigBlock);
        this.signedData = SignedData.getInstance(this.contentInfo.getContent());
    }

    public CMSSignedData(CMSProcessable signedContent, InputStream sigData) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo((InputStream)new ASN1InputStream(sigData)));
    }

    public CMSSignedData(InputStream sigData) throws CMSException {
        this(CMSUtils.readContentInfo(sigData));
    }

    public CMSSignedData(CMSProcessable signedContent, ContentInfo sigData) {
        this.signedContent = signedContent;
        this.contentInfo = sigData;
        this.signedData = SignedData.getInstance(this.contentInfo.getContent());
    }

    public CMSSignedData(ContentInfo sigData) {
        this.contentInfo = sigData;
        this.signedData = SignedData.getInstance(this.contentInfo.getContent());
        this.signedContent = this.signedData.getEncapContentInfo().getContent() != null ? new CMSProcessableByteArray(((ASN1OctetString)this.signedData.getEncapContentInfo().getContent()).getOctets()) : null;
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set s = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            for (int i = 0; i != s.size(); ++i) {
                signerInfos.add(new SignerInformation(SignerInfo.getInstance(s.getObjectAt(i)), this.signedData.getEncapContentInfo().getContentType(), this.signedContent, this.rawDigest));
            }
            this.signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this.signerInfoStore;
    }

    public X509Store getAttributeCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this.attributeStore == null) {
            this.attributeStore = HELPER.createAttributeStore(type, provider, this.signedData.getCertificates());
        }
        return this.attributeStore;
    }

    public X509Store getCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this.certificateStore == null) {
            this.certificateStore = HELPER.createCertificateStore(type, provider, this.signedData.getCertificates());
        }
        return this.certificateStore;
    }

    public X509Store getCRLs(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this.crlStore == null) {
            this.crlStore = HELPER.createCRLsStore(type, provider, this.signedData.getCRLs());
        }
        return this.crlStore;
    }

    public CertStore getCertificatesAndCRLs(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (this.certStore == null) {
            ASN1Set certSet = this.signedData.getCertificates();
            ASN1Set crlSet = this.signedData.getCRLs();
            this.certStore = HELPER.createCertStore(type, provider, certSet, crlSet);
        }
        return this.certStore;
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSProcessable getSignedContent() {
        return this.signedContent;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(this.contentInfo);
        return bOut.toByteArray();
    }

    public static CMSSignedData replaceSigners(CMSSignedData signedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cms = new CMSSignedData(signedData);
        cms.signerInfoStore = signerInformationStore;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            AlgorithmIdentifier digAlgId;
            try {
                digAlgId = CMSSignedData.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
            }
            catch (IOException e) {
                throw new RuntimeException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            vec.add(signer.toSignerInfo());
        }
        DERSet digests = new DERSet(digestAlgs);
        DERSet signers = new DERSet(vec);
        ASN1Sequence sD = (ASN1Sequence)signedData.signedData.getDERObject();
        vec = new ASN1EncodableVector();
        vec.add(sD.getObjectAt(0));
        vec.add(digests);
        for (int i = 2; i != sD.size() - 1; ++i) {
            vec.add(sD.getObjectAt(i));
        }
        vec.add(signers);
        cms.signedData = SignedData.getInstance(new BERSequence(vec));
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), cms.signedData);
        return cms;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData signedData, CertStore certsAndCrls) throws CMSException {
        ASN1Set set;
        CMSSignedData cms = new CMSSignedData(signedData);
        cms.certStore = certsAndCrls;
        ASN1Set certs = null;
        ASN1Set crls = null;
        try {
            set = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certsAndCrls));
            if (set.size() != 0) {
                certs = set;
            }
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting certs from certStore", e);
        }
        try {
            set = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certsAndCrls));
            if (set.size() != 0) {
                crls = set;
            }
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting crls from certStore", e);
        }
        cms.signedData = new SignedData(signedData.signedData.getDigestAlgorithms(), signedData.signedData.getEncapContentInfo(), certs, crls, signedData.signedData.getSignerInfos());
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), cms.signedData);
        return cms;
    }

    private static DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    private static AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), CMSSignedData.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }
}

