/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import kz.gov.pki.kalkan.asn1.cms.KEKIdentifier;
import kz.gov.pki.kalkan.asn1.cms.KEKRecipientInfo;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSTypedStream;
import kz.gov.pki.kalkan.jce.provider.cms.RecipientId;
import kz.gov.pki.kalkan.jce.provider.cms.RecipientInformation;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;

    public KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier encAlg, InputStream data) {
        super(encAlg, AlgorithmIdentifier.getInstance(info.getKeyEncryptionAlgorithm()), data);
        this._info = info;
        this._encAlg = encAlg;
        this._rid = new RecipientId();
        KEKIdentifier kekId = info.getKekid();
        this._rid.setKeyIdentifier(kekId.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        try {
            byte[] encryptedKey = this._info.getEncryptedKey().getOctets();
            Cipher keyCipher = Cipher.getInstance(this._keyEncAlg.getObjectId().getId(), prov);
            keyCipher.init(4, key);
            AlgorithmIdentifier aid = this._encAlg;
            String alg = aid.getObjectId().getId();
            Key sKey = keyCipher.unwrap(encryptedKey, alg, 3);
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
    }
}

