/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;

public class SignerInformationStore {
    private Map table = new HashMap();

    public SignerInformationStore(Collection signerInfos) {
        for (SignerInformation signer : signerInfos) {
            SignerId sid = signer.getSID();
            if (this.table.get(sid) == null) {
                this.table.put(sid, signer);
                continue;
            }
            Object o = this.table.get(sid);
            if (o instanceof List) {
                ((List)o).add(signer);
                continue;
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(o);
            l.add(signer);
            this.table.put(sid, l);
        }
    }

    public SignerInformation get(SignerId selector) {
        Object o = this.table.get(selector);
        if (o instanceof List) {
            return (SignerInformation)((List)o).get(0);
        }
        return (SignerInformation)o;
    }

    public int size() {
        Iterator it = this.table.values().iterator();
        int count = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof List) {
                count += ((List)o).size();
                continue;
            }
            ++count;
        }
        return count;
    }

    public Collection getSigners() {
        ArrayList list = new ArrayList(this.table.size());
        for (Object o : this.table.values()) {
            if (o instanceof List) {
                list.addAll((List)o);
                continue;
            }
            list.add(o);
        }
        return list;
    }

    public Collection getSigners(SignerId selector) {
        Object o = this.table.get(selector);
        if (o instanceof List) {
            return new ArrayList((List)o);
        }
        if (o != null) {
            return Collections.singletonList(o);
        }
        return new ArrayList();
    }
}

