/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.ocsp;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.ResponderID;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.jce.X509Principal;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPUtil;

public class RespID {
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(X500Principal name) {
        try {
            this.id = new ResponderID(new X509Principal(name.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't decode name.");
        }
    }

    public RespID(PublicKey key) throws OCSPException {
        try {
            MessageDigest digest = OCSPUtil.createDigestInstance("SHA1", null);
            ASN1InputStream aIn = new ASN1InputStream(key.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(aIn.readObject());
            digest.update(info.getPublicKeyData().getBytes());
            DEROctetString keyHash = new DEROctetString(digest.digest());
            this.id = new ResponderID(keyHash);
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

