/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSequenceGenerator;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;

public class AKGOST34310PublicKey
implements PublicKey {
    private byte[] keyData;

    public AKGOST34310PublicKey(byte[] keyData) {
        this.keyData = keyData;
    }

    public String getAlgorithm() {
        return "ECGOST34310";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        DERObject params = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DERSequenceGenerator seqGen = new DERSequenceGenerator(baos);
            seqGen.addObject(KNCAObjectIdentifiers.gost34310_2004_PKIGOVKZ_A);
            seqGen.addObject(KNCAObjectIdentifiers.gost34311_95_TestParamSet);
            seqGen.close();
            baos.close();
            ASN1InputStream asn1is = new ASN1InputStream(baos.toByteArray());
            params = asn1is.readObject();
            asn1is.close();
        }
        catch (IOException baos) {
            // empty catch block
        }
        SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(KNCAObjectIdentifiers.gost34310_2004, params), new DEROctetString(this.keyData));
        return pkInfo.getDEREncoded();
    }
}

