/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSequenceGenerator;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;

public class AKRSAPublicKey
implements PublicKey {
    private byte[] modulus;
    private BigInteger publicExponent;

    public AKRSAPublicKey(byte[] modulus) {
        if ((modulus[0] & 0xFF) > 127) {
            this.modulus = new byte[modulus.length + 1];
            System.arraycopy(modulus, 0, this.modulus, 1, modulus.length);
        } else {
            this.modulus = modulus;
        }
        this.publicExponent = BigInteger.valueOf(65537L);
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        byte[] ret = null;
        try {
            ByteArrayOutputStream pkSeqOut = new ByteArrayOutputStream();
            DERSequenceGenerator pkSeqGen = new DERSequenceGenerator(pkSeqOut);
            DERInteger pkModulus = new DERInteger(this.modulus);
            DERInteger pkPubExp = new DERInteger(this.publicExponent);
            pkSeqGen.addObject(pkModulus);
            pkSeqGen.addObject(pkPubExp);
            pkSeqGen.close();
            pkSeqOut.close();
            DERObjectIdentifier oi = new DERObjectIdentifier("1.2.840.113549.1.1.1");
            SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(oi), pkSeqOut.toByteArray());
            ret = pkInfo.getDEREncoded();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return ret;
    }
}

