/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc;

import java.util.HashMap;
import java.util.Map;
import kz.gov.pki.kalkan.exception.KALKANCardException;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.pcsc.tokens.EToken72K;
import kz.gov.pki.kalkan.pcsc.tokens.JaCarta;
import kz.gov.pki.kalkan.pcsc.tokens.KZIDCard;
import kz.gov.pki.kalkan.pcsc.tokens.Kaztoken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TokenDispatcher {
    INSTANCE;

    public final String JACARTA = "AKJaCartaStore";
    public final String KAZTOKEN = "AKKaztokenStore";
    public final String KZIDCARD = "AKKZIDCardStore";
    public final String KORGANS = "AKKorganSStore";
    public final String ETOKEN72K = "AKEtoken72KStore";
    public static final HashMap<Integer, String> storeTypesMap;
    private static final String CN;
    private Map<String, AKToken> tokenMap = new HashMap<String, AKToken>();

    public AKToken instantiateToken(String tType, String tName, String pin) throws KALKANCardException {
        AKToken token = this.tokenMap.get(tName);
        if (token != null) {
            this.tokenMap.remove(tName);
            token = null;
        }
        if (token == null) {
            if (tType.equalsIgnoreCase("AKKaztokenStore")) {
                token = new Kaztoken(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase("AKKZIDCardStore")) {
                token = new KZIDCard(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase("AKEtoken72KStore")) {
                token = new EToken72K(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase("AKJaCartaStore")) {
                token = new JaCarta(tName, pin);
                this.tokenMap.put(tName, token);
            }
        }
        return token;
    }

    public AKToken getToken(String tName) throws KALKANCardException {
        AKToken token = this.tokenMap.get(tName);
        if (token == null) {
            throw new KALKANCardException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getToken", tName + " is not available", null);
        }
        return token;
    }

    public void removeToken(String tName) {
        AKToken token = this.tokenMap.get(tName);
        this.removeToken(token);
    }

    public void removeToken(AKToken token) {
        if (token != null) {
            token.disconnect();
            this.tokenMap.remove(token.getTName());
        }
    }

    static {
        storeTypesMap = new HashMap();
        CN = TokenDispatcher.class.getSimpleName();
    }
}

