/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.keystores;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import javax.smartcardio.CardException;
import kz.gov.pki.kalkan.exception.KALKANCardException;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AKKaztokenStore
extends KeyStoreSpi {
    private AKToken token = null;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey ret = null;
        try {
            ret = this.token.getKey(alias);
        }
        catch (KALKANCardException e) {
            throw new UnrecoverableKeyException(e.getTopMessage());
        }
        return ret;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate ret = null;
        try {
            byte[] cert = this.token.getCertificate(alias);
            if (cert != null) {
                ret = CertificateFactory.getInstance("X509", "KALKAN").generateCertificate(new ByteArrayInputStream(cert));
            }
        }
        catch (CertificateException e) {
            System.err.println(e.getMessage());
        }
        catch (KALKANCardException e) {
            System.err.println(e.getTopMessage());
        }
        catch (NoSuchProviderException e) {
            System.err.println(e.getMessage());
        }
        return ret;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        try {
            this.token.setCertificate(alias, cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e.getMessage());
        }
        catch (KALKANCardException e) {
            throw new KeyStoreException(e.getTopMessage());
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        try {
            this.token.deleteEntry(alias);
        }
        catch (CardException e) {
            throw new KeyStoreException(e.getMessage());
        }
        catch (KALKANCardException e) {
            throw new KeyStoreException(e.getTopMessage());
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        Enumeration<String> ret = null;
        try {
            ret = Collections.enumeration(this.token.getAliases());
        }
        catch (KALKANCardException e) {
            System.err.println(e.getTopMessage());
        }
        return ret;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int engineSize() {
        int ret = 0;
        try {
            ret = this.token.getAliases().size();
        }
        catch (KALKANCardException e) {
            System.err.println(e.getTopMessage());
        }
        return ret;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        TokenDispatcher.INSTANCE.removeToken(this.token);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            throw new IOException("Stream is null");
        }
        if (password == null) {
            throw new IOException("Password is null");
        }
        String tName = new String(Streams.readAll(stream));
        String pin = String.valueOf(password);
        try {
            this.token = TokenDispatcher.INSTANCE.instantiateToken(TokenDispatcher.INSTANCE.KAZTOKEN, tName, pin);
        }
        catch (KALKANCardException e) {
            throw new IOException(e);
        }
    }
}

