/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.tokens;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import kz.gov.pki.kalkan.exception.JaCartaException;
import kz.gov.pki.kalkan.exception.KALKANCardException;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.ByteUtils;
import kz.gov.pki.kalkan.util.encoders.Hex;

public final class JaCarta
extends AKToken {
    private static final String CN = JaCarta.class.getSimpleName();
    private static final byte[] aid = new byte[]{-96, 0, 103, 97, 109, 109, 97, 116, 101, 99, 104, 0};
    private Map<String, Byte> aliases = null;
    private Map<Byte, String> revAliases = null;

    public JaCarta(String tName, String pin) throws KALKANCardException {
        super(tName, pin);
        this.connect();
        try {
            this.capdu = new CommandAPDU(0, 164, 4, 0, aid);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "Constructor", tName + " is not JACARTA", null);
            }
            this.capdu = new CommandAPDU(128, 21, 32, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(128, 21, 33, 0, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            int nullPos = ByteUtils.indexOf(this.respApdu.getData(), new byte[]{0, 0}, 5);
            byte[] tokensn = new byte[nullPos - 5];
            System.arraycopy(this.respApdu.getData(), 5, tokensn, 0, nullPos - 5);
            this.tokenId = Hex.encodeStr(tokensn);
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "Constructor", ce.getMessage(), null);
        }
        if (!pin.equals("guest")) {
            this.verifyPin(pin);
        }
        this.aliases = new LinkedHashMap<String, Byte>();
        this.revAliases = new LinkedHashMap<Byte, String>();
        this.getAliases();
    }

    public void disconnect() {
        try {
            if (this.sc != null) {
                this.sc.disconnect(false);
            }
        }
        catch (CardException e) {
            this.debugOut(e.getMessage());
        }
    }

    protected void verifyPin(String pin) throws KALKANCardException {
        if (pin == null || pin.length() == 0) {
            throw new JaCartaException(KALKANCardException.ICCodes.VERIFYPIN.name(), CN, "verifyPin", "Pin is null", null);
        }
        try {
            this.capdu = new CommandAPDU(128, 16, 33, 0, pin.getBytes());
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                String sw = Integer.toHexString(this.respApdu.getSW());
                throw new JaCartaException(KALKANCardException.ICCodes.VERIFYPIN.name(), CN, "verifyPin", "Status: " + sw, null);
            }
            this.debugOut("Log on... ok!");
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "verifyPin", ce.getMessage(), null);
        }
    }

    private byte[] getPublicKeyRSA(byte[] objName) throws CardException {
        this.debugOut("Get RAW RSA public key");
        byte[] pubKey = new byte[256];
        this.capdu = new CommandAPDU(128, 18, 37, 0, objName);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException("Could not get public key: " + this.respApdu.getSW());
        }
        System.arraycopy(this.respApdu.getData(), 3, pubKey, 0, 256);
        return pubKey;
    }

    private byte[] getPublicKeyGOST(byte[] objName) throws CardException {
        this.debugOut("Get RAW GOST public key");
        byte[] pubKey = new byte[64];
        byte[] part = new byte[32];
        this.capdu = new CommandAPDU(128, 17, 33, 0, objName);
        this.respApdu = this.ch.transmit(this.capdu);
        pubKey = this.respApdu.getData();
        System.arraycopy(pubKey, 0, part, 0, 32);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, pubKey, 0, part.length);
        System.arraycopy(pubKey, 32, part, 0, part.length);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, pubKey, 32, part.length);
        return pubKey;
    }

    public byte[] getPublicKey(String algName, byte keyId) throws CardException {
        byte[] ret = null;
        byte[] objName = JaCarta.getAliasAsByteArray(this.revAliases.get(keyId));
        if (algName.equals("GOST")) {
            ret = this.getPublicKeyGOST(objName);
        } else if (algName.equals("RSA")) {
            ret = this.getPublicKeyRSA(objName);
        }
        return ret;
    }

    private byte[] signGOST(byte[] data, byte[] objName) throws CardException {
        this.debugOut("GOST signing");
        byte[] sign = new byte[64];
        byte[] part = new byte[32];
        byte[] forSign = new byte[objName.length + data.length];
        System.arraycopy(objName, 0, forSign, 0, objName.length);
        data = ByteUtils.inverseCopyByte(data, 0, data.length);
        System.arraycopy(data, 0, forSign, objName.length, data.length);
        this.capdu = new CommandAPDU(128, 20, 32, 0, forSign);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException("Erron on sign: " + this.respApdu.getSW());
        }
        sign = this.respApdu.getData();
        System.arraycopy(sign, 0, part, 0, 32);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, sign, 0, part.length);
        System.arraycopy(sign, 32, part, 0, part.length);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, sign, 32, part.length);
        return sign;
    }

    private byte[] signRSA(byte[] data, byte[] objName) throws CardException {
        this.debugOut("RSA signing");
        byte[] hash = data;
        byte[] forSign = new byte[256];
        forSign[0] = 0;
        forSign[1] = 1;
        for (int i = 2; i < forSign.length - hash.length - 1; ++i) {
            forSign[i] = -1;
        }
        System.arraycopy(hash, 0, forSign, forSign.length - hash.length, hash.length);
        byte[] objNameSgn = new byte[objName.length + 2 + forSign.length];
        objNameSgn[objName.length] = 1;
        System.arraycopy(objName, 0, objNameSgn, 0, objName.length);
        System.arraycopy(forSign, 0, objNameSgn, objName.length + 2, forSign.length);
        this.capdu = new CommandAPDU(128, 20, 35, 36, objNameSgn);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException("Erron on sign: " + this.respApdu.getSW());
        }
        byte[] sign = this.respApdu.getData();
        return sign;
    }

    public byte[] sign(String algName, byte[] data, byte keyId) throws CardException {
        byte[] ret = null;
        byte[] objName = JaCarta.getAliasAsByteArray(this.revAliases.get(keyId));
        if (algName.equals("GOST")) {
            ret = this.signGOST(data, objName);
        } else if (algName.equals("RSA")) {
            ret = this.signRSA(data, objName);
        }
        return ret;
    }

    private void genKeyPairRSA(byte[] objName) throws JaCartaException {
        try {
            this.debugOut("RSA key pair generation");
            byte[] forKG = new byte[objName.length + 3];
            forKG[0] = 8;
            forKG[2] = 8;
            System.arraycopy(objName, 0, forKG, 3, objName.length);
            this.capdu = new CommandAPDU(128, 17, 35, 0, forKG);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new JaCartaException(KALKANCardException.ICCodes.GENKEY.name(), CN, "genRSAKeyPair", "Status: " + this.respApdu.getSW(), null);
            }
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "genRSAKeyPair", ce.getMessage(), null);
        }
    }

    private void genKeyPairGOST(byte[] objName) throws JaCartaException {
        try {
            this.debugOut("GOST key pair generation");
            byte[] forKG = new byte[objName.length + 1];
            forKG[0] = 1;
            System.arraycopy(objName, 0, forKG, 1, objName.length);
            this.capdu = new CommandAPDU(128, 17, 32, 0, forKG);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new JaCartaException(KALKANCardException.ICCodes.GENKEY.name(), CN, "genGOSTKeyPair", "Status: " + this.respApdu.getSW(), null);
            }
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "genGOSTKeyPair", ce.getMessage(), null);
        }
    }

    public byte generateKeyPair(String algName, String alias, boolean isXch, int keyLength) throws KALKANCardException {
        byte[] objName = JaCarta.getAliasAsByteArray(alias);
        if (algName.equals("GOST")) {
            this.genKeyPairGOST(objName);
        } else if (algName.equals("RSA")) {
            this.genKeyPairRSA(objName);
        } else {
            throw new JaCartaException(KALKANCardException.ICCodes.GENKEY.name(), CN, "generateKeyPair", "Unknown algorithm", null);
        }
        byte ret = (byte)(this.getAliases().size() - 1);
        return ret;
    }

    public void setCertificate(String alias, byte[] certificate) throws KALKANCardException {
        byte[] objName = JaCarta.getAliasAsByteArray(alias);
        try {
            ByteArrayOutputStream gzbaos = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(gzbaos);
            gzout.write(certificate);
            gzout.close();
            gzbaos.close();
            this.debugOut("Certificate has been GZipped");
            byte[] gzcer = gzbaos.toByteArray();
            if (gzcer.length > 2048) {
                throw new JaCartaException(KALKANCardException.ICCodes.TOOBIGCERTSIZE.name(), CN, "setCertificate", "Too big certificate > 2048", null);
            }
            short certSize = (short)gzcer.length;
            this.debugOut("was: " + certificate.length + "; now: " + certSize);
            byte[] forCert = new byte[2 + objName.length + gzcer.length];
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(certSize);
            bb.clear();
            bb.get(forCert, 0, 2);
            System.arraycopy(objName, 0, forCert, 2, objName.length);
            System.arraycopy(gzcer, 0, forCert, objName.length + 2, gzcer.length);
            this.capdu = new CommandAPDU(128, 18, 39, 0, forCert);
            this.respApdu = this.ch.transmit(this.capdu);
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "setCertificate", ce.getMessage(), null);
        }
        catch (IOException ioe) {
            throw new JaCartaException(KALKANCardException.ICCodes.IOEXCEPTION.name(), CN, "setCertificate", ioe.getMessage(), null);
        }
    }

    public byte[] getCertificate(String alias) throws KALKANCardException {
        byte[] ret = null;
        try {
            this.capdu = new CommandAPDU(128, 18, 40, 0, JaCarta.getAliasAsByteArray(alias));
            this.respApdu = this.ch.transmit(this.capdu);
            byte[] gzcert = this.respApdu.getBytes();
            ByteArrayOutputStream ungzbaos = new ByteArrayOutputStream();
            ByteArrayInputStream gzbais = new ByteArrayInputStream(gzcert);
            try {
                this.debugOut("UnGZipping certificate");
                GZIPInputStream gzin = new GZIPInputStream(gzbais);
                int c = gzin.read();
                while (c != -1) {
                    ungzbaos.write(c);
                    c = gzin.read();
                }
                gzin.close();
                gzbais.close();
                ungzbaos.close();
                ret = ungzbaos.toByteArray();
                this.debugOut("cert: " + ret.length);
            }
            catch (IOException ioe) {
                ret = gzcert;
            }
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getCertificate", ce.getMessage(), null);
        }
        return ret;
    }

    public Set getAliases() throws KALKANCardException {
        try {
            this.capdu = new CommandAPDU(128, 18, 34, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.put(this.respApdu.getData());
            short c = bb.getShort(0);
            for (short i = 0; i < c; i = (short)(i + 1)) {
                bb.clear();
                bb.putShort(0, i);
                byte[] b = new byte[2];
                bb.get(b);
                this.capdu = new CommandAPDU(128, 18, 33, 0, b);
                this.respApdu = this.ch.transmit(this.capdu);
                byte[] objNameRaw = this.respApdu.getData();
                int nullPos = ByteUtils.indexOf(this.respApdu.getData(), new byte[]{0}, 0);
                byte[] objName = new byte[nullPos + 2];
                objName[0] = 0;
                objName[1] = (byte)nullPos;
                System.arraycopy(objNameRaw, 0, objName, 2, nullPos);
                this.aliases.put(Hex.encodeStr(objNameRaw).substring(0, nullPos * 2), (byte)i);
                this.revAliases.put((byte)i, Hex.encodeStr(objNameRaw).substring(0, nullPos * 2));
            }
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getAliases", ce.getMessage(), null);
        }
        return this.aliases.keySet();
    }

    public PrivateKey getKey(String alias) throws KALKANCardException {
        PrivateKey ret = null;
        try {
            byte[] objName = JaCarta.getAliasAsByteArray(alias);
            byte[] objNameChk = new byte[objName.length + 2];
            System.arraycopy(objName, 0, objNameChk, 0, objName.length);
            this.capdu = new CommandAPDU(128, 18, 36, 0, objNameChk);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                return new AKGOST34310PrivateKey(this, this.aliases.get(alias));
            }
            objNameChk[objNameChk.length - 1] = 3;
            this.capdu = new CommandAPDU(128, 18, 36, 0, objNameChk);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                return new AKRSAPrivateKey(this, this.aliases.get(alias));
            }
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getKey", ce.getMessage(), null);
        }
        return ret;
    }

    public byte[] getRandom(int lc) {
        return null;
    }

    private void debugOut(String s) {
        System.out.println("[JaCarta]> " + s);
    }

    public void deleteEntry(String alias) throws CardException, KALKANCardException {
        this.debugOut("Deleting " + alias);
        try {
            byte[] objName = JaCarta.getAliasAsByteArray(alias);
            this.capdu = new CommandAPDU(128, 18, 35, 0, objName);
            this.respApdu = this.ch.transmit(this.capdu);
        }
        catch (CardException ce) {
            throw new JaCartaException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "deleteEntry", ce.getMessage(), null);
        }
    }

    private static byte[] getAliasAsByteArray(String alias) {
        byte[] b = Hex.decode(alias);
        byte[] ret = new byte[b.length + 2];
        ret[0] = 0;
        ret[1] = (byte)b.length;
        System.arraycopy(b, 0, ret, 2, b.length);
        return ret;
    }
}

