/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.tokens;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import kz.gov.pki.kalkan.exception.KALKANCardException;
import kz.gov.pki.kalkan.exception.KaztokenException;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.parsers.MapFileParser;
import kz.gov.pki.kalkan.pcsc.parsers.TLVParser;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.Arrays;
import kz.gov.pki.kalkan.util.ByteUtils;
import kz.gov.pki.kalkan.util.encoders.Hex;

public final class Kaztoken
extends AKToken {
    private static final String CN = Kaztoken.class.getSimpleName();
    private static final short MIN_FREEMEM_FOR_CERT = 5120;
    private static final short MIN_FREEMEM_FOR_KEY = 2048;

    public Kaztoken(String tName, String pin) throws KALKANCardException {
        super(tName, pin);
        this.connect();
        try {
            this.capdu = new CommandAPDU(0, 202, 1, 129, 255);
            this.respApdu = this.ch.transmit(this.capdu);
            this.tokenId = Hex.encodeStr(this.respApdu.getData()).substring(8);
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "Constructor", ce.getMessage(), null);
        }
        if (!pin.equals("guest")) {
            this.verifyPin(pin);
        }
    }

    protected void verifyPin(String pin) throws KALKANCardException {
        if (pin == null || pin.length() == 0) {
            throw new KaztokenException(KALKANCardException.ICCodes.VERIFYPIN.name(), CN, "verifyPin", "Pin is null", null);
        }
        try {
            this.reset();
            this.capdu = new CommandAPDU(0, 32, 0, 2, pin.getBytes());
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                this.capdu = new CommandAPDU(0, 32, 0, 2);
                this.respApdu = this.ch.transmit(this.capdu);
                if (this.respApdu.getSW1() == 99) {
                    if (this.respApdu.getSW2() == 0) {
                        throw new KaztokenException(KALKANCardException.ICCodes.VERIFYPIN.name(), CN, "verifyPin", "Status: 0x6300", null);
                    }
                    int retryCount = Character.getNumericValue(Integer.toHexString(this.respApdu.getSW2()).charAt(1));
                    throw new KaztokenException(KALKANCardException.ICCodes.VERIFYPIN.name(), CN, "verifyPin", String.valueOf(retryCount), null);
                }
                String sw = Integer.toHexString(this.respApdu.getSW());
                throw new KaztokenException(KALKANCardException.ICCodes.VERIFYPIN.name(), CN, "verifyPin", "Status: " + sw, null);
            }
            this.debugOut("Log on... ok!");
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "verifyPin", ce.getMessage(), null);
        }
    }

    private int getAvailableMemorySize() {
        int ret = 0;
        try {
            this.capdu = new CommandAPDU(0, 202, 1, 138, 255);
            this.respApdu = this.ch.transmit(this.capdu);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(this.respApdu.getData());
            this.debugOut("Available (bytes): " + bb.getInt(0));
            ret = bb.getInt(0);
        }
        catch (CardException cardException) {
            // empty catch block
        }
        return ret;
    }

    private MapFileParser getMapFile() throws CardException {
        MapFileParser mapParser = null;
        this.debugOut("reading map file...");
        this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 16, 16, 16});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        if (this.respApdu.getSW() == 27266) {
            this.debugOut("Creating map DF");
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 29, -126, 2, 56, 0, -128, 2, 0, 16, -125, 2, 16, 16, -122, 15, 67, 2, 2, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864 && this.respApdu.getSW() != 27273) {
                throw new CardException("Could not create map file");
            }
            mapParser = new MapFileParser(null);
        } else {
            this.capdu = new CommandAPDU(0, -92, 0, 4, new byte[]{16, 16}, 255);
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            TLVParser tlvParser = new TLVParser(this.respApdu.getData());
            mapParser = new MapFileParser(this.readBinary((short)0, tlvParser.getFileLen()));
        }
        return mapParser;
    }

    private MapFileParser updateMapFile(String alias, boolean isRemoval) throws CardException, IOException {
        MapFileParser mapParser = this.getMapFile();
        if (alias == null) {
            throw new CardException("Alias is null");
        }
        if (isRemoval) {
            if (!mapParser.getRevMapFile().containsKey(alias)) {
                throw new CardException(alias + " does not exists");
            }
        } else {
            if (mapParser.getNewId() == 255) {
                throw new CardException("Maximum File ID has been reached.");
            }
            if (mapParser.getRevMapFile().containsKey(alias)) {
                throw new CardException(alias + " already exists");
            }
        }
        this.debugOut("Updating map file...");
        ByteBuffer fileSize = ByteBuffer.allocate(2);
        fileSize.putShort(isRemoval ? (short)(mapParser.getSize() - alias.length() - 2) : (short)(mapParser.getSize() + alias.length() + 2));
        this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 16});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        this.capdu = new CommandAPDU(0, -28, 0, 0, new byte[]{16, 16});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 29, -126, 2, 1, 0, -128, 2, fileSize.get(0), fileSize.get(1), -125, 2, 16, 16, -122, 15, 66, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        byte[] newMap = mapParser.updateData(alias, isRemoval);
        this.writeBinary(newMap, (short)0, (short)newMap.length);
        return mapParser;
    }

    private void reset() throws CardException {
        this.capdu = new CommandAPDU(128, 64, 0, 0, 0);
        this.respApdu = this.ch.transmit(this.capdu);
    }

    public void disconnect() {
        try {
            this.reset();
            this.sc.disconnect(false);
        }
        catch (CardException e) {
            this.debugOut(e.getMessage());
        }
    }

    private void debugOut(String s) {
        System.out.println("[Kaztoken]> " + s);
    }

    private byte[] signGOST(byte[] data, byte keyId) throws CardException {
        this.debugOut("GOST signing");
        this.capdu = new CommandAPDU(0, 34, 65, 182, new byte[]{-111, 1, 64, -124, 1, keyId});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        this.capdu = new CommandAPDU(0, 42, 158, 154, data, 64);
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException("Erron on sign: " + this.respApdu.getSW());
        }
        byte[] sign = this.respApdu.getData();
        return sign;
    }

    private byte[] signRSA(byte[] data, byte keyId) throws CardException {
        this.debugOut("RSA signing");
        byte[] hash = data;
        Arrays.reverse(hash);
        this.capdu = new CommandAPDU(0, 34, 65, 182, new byte[]{-107, 1, 64, -124, 1, keyId});
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        int mLen = this.getPublicKeyRSA(keyId).length;
        byte[] part = new byte[mLen - hash.length];
        int l = part.length;
        part[l - 1] = 0;
        part[l - 2] = 1;
        for (int i = 1; i < l - 2; ++i) {
            part[i] = -1;
        }
        this.capdu = new CommandAPDU(16, 42, 158, 154, hash);
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        int o = 0;
        while (o < l - 1) {
            byte[] sdata;
            if (o + 255 < l) {
                sdata = new byte[255];
                System.arraycopy(part, o, sdata, 0, 255);
                this.capdu = new CommandAPDU(16, 42, 158, 154, sdata);
                this.respApdu = this.ch.transmit(this.capdu);
                System.out.println(this.respApdu);
                o += 255;
                continue;
            }
            sdata = new byte[l - o];
            System.arraycopy(part, o, sdata, 0, sdata.length);
            this.capdu = new CommandAPDU(0, 42, 158, 154, sdata, mLen < 256 ? mLen : 256);
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            o = l;
        }
        if (this.respApdu.getSW() != 36864) {
            throw new CardException("Erron on sign: " + this.respApdu.getSW());
        }
        byte[] sgn = this.respApdu.getData();
        Arrays.reverse(sgn);
        return sgn;
    }

    private byte[] getPublicKeyRSA(byte keyId) throws CardException {
        this.debugOut("Get RAW RSA public key");
        this.capdu = new CommandAPDU(0, 70, 129, (int)keyId, 256);
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        byte[] modulus = this.respApdu.getData();
        modulus = ByteUtils.inverseCopyByte(modulus, 0, modulus.length);
        return modulus;
    }

    private byte[] getPublicKeyGOST(byte keyId) throws CardException {
        this.debugOut("Get RAW GOST public key");
        this.capdu = new CommandAPDU(0, 70, 129, (int)keyId, 64);
        this.respApdu = this.ch.transmit(this.capdu);
        System.out.println(this.respApdu);
        return this.respApdu.getData();
    }

    public byte[] getPublicKey(String algName, byte keyId) throws CardException {
        byte[] ret = null;
        if (algName.equals("GOST")) {
            ret = this.getPublicKeyGOST(keyId);
        } else if (algName.equals("RSA")) {
            ret = this.getPublicKeyRSA(keyId);
        }
        return ret;
    }

    public byte[] sign(String algName, byte[] data, byte keyId) throws CardException {
        byte[] ret = null;
        if (algName.equals("GOST")) {
            ret = this.signGOST(data, keyId);
        } else if (algName.equals("RSA")) {
            ret = this.signRSA(data, keyId);
        }
        return ret;
    }

    private byte genKeyPairRSA(String alias, boolean isXch, int keyLength) throws KaztokenException {
        byte ret;
        try {
            ByteBuffer bb = ByteBuffer.allocate(2);
            int keyHalf = keyLength / 8 / 2;
            bb.putShort((short)(keyHalf * 5 + 8));
            MapFileParser mapParser = this.updateMapFile(alias, false);
            this.debugOut("RSA key generation");
            byte newId = mapParser.getNewId();
            byte destiny = (byte)(isXch ? 1 : 0);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, bb.get(0), bb.get(1), -125, 2, 0, newId, -123, 6, 35, 0, destiny, -1, 0, 0, -122, 15, 71, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            bb.clear();
            bb.putShort((short)(keyHalf * 3));
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, bb.get(0), bb.get(1), -125, 2, 0, newId, -123, 6, 51, 0, destiny, -1, 0, 0, -122, 15, 70, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            this.capdu = new CommandAPDU(0, 70, 0, newId);
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KaztokenException(KALKANCardException.ICCodes.GENKEY.name(), CN, "genKeyRSAAndGetPKCS10", "Status: " + this.respApdu.getSW(), null);
            }
            ret = newId;
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "genKeyRSAAndGetPKCS10", ce.getMessage(), null);
        }
        catch (IOException ioe) {
            throw new KaztokenException(KALKANCardException.ICCodes.IOEXCEPTION.name(), CN, "genKeyRSAAndGetPKCS10", ioe.getMessage(), null);
        }
        return ret;
    }

    private byte genKeyPairGOST(String alias) throws KaztokenException {
        byte ret;
        try {
            MapFileParser mapParser = this.updateMapFile(alias, false);
            this.debugOut("GOST key generation");
            byte newId = mapParser.getNewId();
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, 0, 32, -125, 2, 0, newId, -123, 6, 3, 32, 0, -1, 0, 0, -122, 15, 71, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 37, -126, 2, 16, 0, -128, 2, 0, 64, -125, 2, 0, newId, -123, 6, 19, 32, 0, -1, 0, 0, -122, 15, 70, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            this.capdu = new CommandAPDU(0, 70, 0, newId);
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KaztokenException(KALKANCardException.ICCodes.GENKEY.name(), CN, "genKeyAndGetPKCS10", "Status: " + this.respApdu.getSW(), null);
            }
            ret = newId;
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "genKeyAndGetPKCS10", ce.getMessage(), null);
        }
        catch (IOException ioe) {
            throw new KaztokenException(KALKANCardException.ICCodes.IOEXCEPTION.name(), CN, "genKeyAndGetPKCS10", ioe.getMessage(), null);
        }
        return ret;
    }

    public byte generateKeyPair(String algName, String alias, boolean isXch, int keyLength) throws KaztokenException {
        byte ret;
        if (this.getAvailableMemorySize() < 2048) {
            throw new KaztokenException(KALKANCardException.ICCodes.GENKEY.name(), CN, "generateKeyPair", "Available memory size < 2048", null);
        }
        if (algName.equals("GOST")) {
            ret = this.genKeyPairGOST(alias);
        } else if (algName.equals("RSA")) {
            ret = this.genKeyPairRSA(alias, isXch, keyLength);
        } else {
            throw new KaztokenException(KALKANCardException.ICCodes.GENKEY.name(), CN, "generateKeyPair", "Unknown algorithm", null);
        }
        return ret;
    }

    private void setCertificate(byte fileId, byte[] certificate) throws KALKANCardException {
        try {
            ByteArrayOutputStream gzbaos = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(gzbaos);
            gzout.write(certificate);
            gzout.close();
            gzbaos.close();
            this.debugOut("Certificate has been GZipped");
            byte[] gzcer = gzbaos.toByteArray();
            if (gzcer.length > 2048) {
                throw new KaztokenException(KALKANCardException.ICCodes.TOOBIGCERTSIZE.name(), CN, "setCertificate", "Too big certificate > 2048", null);
            }
            short certSize = (short)gzcer.length;
            this.debugOut("was: " + certificate.length + "; now: " + certSize);
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(certSize);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4});
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4, 0, fileId});
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0, new byte[]{0, fileId});
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            this.capdu = new CommandAPDU(0, -32, 0, 0, new byte[]{98, 29, -126, 2, 1, 0, -128, 2, bb.get(0), bb.get(1), -125, 2, 0, fileId, -122, 15, 66, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0});
            this.respApdu = this.ch.transmit(this.capdu);
            this.writeBinary(gzcer, (short)0, certSize);
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "setCertificate", ce.getMessage(), null);
        }
        catch (IOException ioe) {
            throw new KaztokenException(KALKANCardException.ICCodes.IOEXCEPTION.name(), CN, "setCertificate", ioe.getMessage(), null);
        }
    }

    public void setCertificate(String alias, byte[] certificate) throws KALKANCardException {
        if (this.getAvailableMemorySize() < 5120) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "setCertificate", "Available memory size < 5120", null);
        }
        try {
            this.setCertificate(this.getMapFile().getRevMapFile().get(alias), certificate);
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "setCertificate", ce.getMessage(), null);
        }
    }

    public byte[] getCertificate(String alias) throws KALKANCardException {
        byte[] ret = null;
        try {
            ret = this.getCertificate(this.getMapFile().getRevMapFile().get(alias));
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getCertificate", ce.getMessage(), null);
        }
        return ret;
    }

    private byte[] getCertificate(byte fileId) throws KALKANCardException {
        this.debugOut("Get certificate");
        byte[] ret = null;
        try {
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4, 0, fileId}, 256);
            this.respApdu = this.ch.transmit(this.capdu);
            System.out.println(this.respApdu);
            if (this.respApdu.getSW() != 36864) {
                return null;
            }
            TLVParser tlvParser = new TLVParser(this.respApdu.getData());
            short certSize = tlvParser.getFileLen();
            byte[] certificate = this.readBinary((short)0, certSize);
            ByteArrayOutputStream ungzbaos = new ByteArrayOutputStream();
            ByteArrayInputStream gzbais = new ByteArrayInputStream(certificate);
            try {
                this.debugOut("Certificate ungzipping");
                GZIPInputStream gzin = new GZIPInputStream(gzbais);
                int c = gzin.read();
                while (c != -1) {
                    ungzbaos.write(c);
                    c = gzin.read();
                }
                gzin.close();
                gzbais.close();
                ungzbaos.close();
                ret = ungzbaos.toByteArray();
            }
            catch (IOException ioe) {
                ret = certificate;
            }
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getCertificate", ce.getMessage(), null);
        }
        return ret;
    }

    public Set getAliases() throws KALKANCardException {
        try {
            return this.getMapFile().getRevMapFile().keySet();
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getAliases", ce.getMessage(), null);
        }
    }

    public PrivateKey getKey(String alias) throws KALKANCardException {
        PrivateKey ret = null;
        try {
            Byte id = this.getMapFile().getRevMapFile().get(alias);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 2, 0, id}, 256);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                if (ByteUtils.indexOf(this.respApdu.getData(), new byte[]{-123, 6, 3}, 0) != -1) {
                    ret = new AKGOST34310PrivateKey(this, id);
                } else if (ByteUtils.indexOf(this.respApdu.getData(), new byte[]{-123, 6, 35}, 0) != -1) {
                    ret = new AKRSAPrivateKey(this, id);
                }
            }
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "getKey", ce.getMessage(), null);
        }
        return ret;
    }

    public byte[] getRandom(int lc) {
        byte[] ret = null;
        try {
            this.capdu = new CommandAPDU(0, 132, 0, 0, lc > 256 ? 256 : lc);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                ret = this.respApdu.getData();
            }
        }
        catch (CardException cardException) {
            // empty catch block
        }
        return ret;
    }

    public void deleteEntry(String alias) throws CardException, KALKANCardException {
        try {
            Byte id = this.getMapFile().getRevMapFile().get(alias);
            this.updateMapFile(alias, true);
            this.debugOut("Deleting " + alias);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 1, 0, id});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 2, 0, id});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -92, 8, 4, new byte[]{16, 0, 16, 0, 96, 4, 0, id});
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(0, -28, 0, 0);
            this.respApdu = this.ch.transmit(this.capdu);
        }
        catch (CardException ce) {
            throw new KaztokenException(KALKANCardException.ICCodes.CARDEXCEPTION.name(), CN, "deleteEntry", ce.getMessage(), null);
        }
        catch (IOException ioe) {
            throw new KaztokenException(KALKANCardException.ICCodes.IOEXCEPTION.name(), CN, "deleteEntry", ioe.getMessage(), null);
        }
    }
}

