/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.tsp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DERBoolean;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.tsp.MessageImprint;
import kz.gov.pki.kalkan.tsp.TimeStampReq;
import kz.gov.pki.kalkan.tsp.TimeStampRequest;

public class TimeStampRequestGenerator {
    private DERObjectIdentifier reqPolicy;
    private DERBoolean certReq;
    private Hashtable extensions = new Hashtable();
    private Vector extOrdering = new Vector();

    public void setReqPolicy(String reqPolicy) {
        this.reqPolicy = new DERObjectIdentifier(reqPolicy);
    }

    public void setCertReq(boolean certReq) {
        this.certReq = new DERBoolean(certReq);
    }

    public void addExtension(String OID, boolean critical, ASN1Encodable value) throws IOException {
        this.addExtension(OID, critical, value.getEncoded());
    }

    public void addExtension(String OID, boolean critical, byte[] value) {
        DERObjectIdentifier oid = new DERObjectIdentifier(OID);
        this.extensions.put(oid, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
        this.extOrdering.addElement(oid);
    }

    public TimeStampRequest generate(String digestAlgorithm, byte[] digest) {
        return this.generate(digestAlgorithm, digest, null);
    }

    public TimeStampRequest generate(String digestAlgorithmOID, byte[] digest, BigInteger nonce) {
        if (digestAlgorithmOID == null) {
            throw new IllegalArgumentException("No digest algorithm specified");
        }
        DERObjectIdentifier digestAlgOID = new DERObjectIdentifier(digestAlgorithmOID);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(digestAlgOID, new DERNull());
        MessageImprint messageImprint = new MessageImprint(algID, digest);
        X509Extensions ext = null;
        if (this.extOrdering.size() != 0) {
            ext = new X509Extensions(this.extOrdering, this.extensions);
        }
        if (nonce != null) {
            return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, new DERInteger(nonce), this.certReq, ext));
        }
        return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, null, this.certReq, ext));
    }
}

