/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.util;

public class ByteUtils {
    public static final String hexChars = "0123456789ABCDEF";

    public static String toHexByte(int paramInt) {
        return "" + hexChars.charAt(paramInt >> 4 & 0xF) + hexChars.charAt(paramInt & 0xF);
    }

    public static String array2hex(byte[] paramArrayOfByte) {
        String str = new String();
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            str = str + ByteUtils.toHexByte(paramArrayOfByte[i]);
        }
        return str;
    }

    public static int byteToInt(byte[] paramArrayOfByte, int paramInt) {
        return paramArrayOfByte[paramInt++] & 0xFF | (paramArrayOfByte[paramInt++] & 0xFF) << 8 | (paramArrayOfByte[paramInt++] & 0xFF) << 16 | paramArrayOfByte[paramInt++] << 24;
    }

    public static byte[] intToByte(int paramInt) {
        byte[] arrayOfByte = new byte[4];
        arrayOfByte[3] = (byte)paramInt;
        arrayOfByte[2] = (byte)(paramInt >>> 8);
        arrayOfByte[1] = (byte)(paramInt >>> 16);
        arrayOfByte[0] = (byte)(paramInt >>> 24);
        return arrayOfByte;
    }

    public static byte[] copyByte(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        byte[] arrayOfByte = new byte[paramInt2];
        for (int i = 0; i < paramInt2; ++i) {
            arrayOfByte[i] = paramArrayOfByte[paramInt1 + i];
        }
        return arrayOfByte;
    }

    public static byte[] inverseCopyByte(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        byte[] arrayOfByte = new byte[paramInt2];
        for (int i = 0; i < paramInt2; ++i) {
            arrayOfByte[paramInt2 - i - 1] = paramArrayOfByte[paramInt1 + i];
        }
        return arrayOfByte;
    }

    public static int indexOf(byte[] data, byte[] pattern, int offset) {
        int[] failure = ByteUtils.computeFailure(pattern);
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = offset; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

