/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.util;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.pkcs.CertificationRequestInfo;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.GeneralName;
import kz.gov.pki.kalkan.asn1.x509.GeneralNames;
import kz.gov.pki.kalkan.asn1.x509.SubjectKeyIdentifier;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.asn1.x509.X509ExtensionsGenerator;
import kz.gov.pki.kalkan.crypto.digests.SHA1Digest;
import kz.gov.pki.kalkan.jce.PKCS10CertificationRequest;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.kalkan.x509.X509Attribute;

public class KALKANUtils {
    public static String getKeyIdFromPK(PublicKey publicKey) {
        byte[] keyData = publicKey.getEncoded();
        return KALKANUtils.getKeyIdFromPKData(keyData);
    }

    public static String getKeyIdFromPKData(byte[] keyData) {
        byte[] hash = new byte[20];
        SHA1Digest digest = new SHA1Digest();
        digest.update(keyData, 0, keyData.length);
        digest.doFinal(hash, 0);
        return Hex.encodeStr(hash);
    }

    public static String generateKeyIdFromRequest(String certRequest) {
        if (certRequest != null && !certRequest.isEmpty()) {
            String result = null;
            ASN1Sequence seq = null;
            try {
                int p;
                StringBuilder sb = new StringBuilder(certRequest);
                if (sb.indexOf("-----BEGIN NEW CERTIFICATE REQUEST-----") == 0) {
                    sb.delete(0, 39);
                }
                if ((p = sb.indexOf("-----END NEW CERTIFICATE REQUEST-----")) != -1) {
                    sb.delete(p, sb.length());
                }
                certRequest = sb.toString().replace("\n", "").trim();
                seq = (ASN1Sequence)ASN1Object.fromByteArray(Base64.decode(certRequest));
                PKCS10CertificationRequest pkcscr = new PKCS10CertificationRequest(seq);
                result = KALKANUtils.getKeyIdFromPK(pkcscr.getPublicKey());
                System.err.println("generated Key id from request " + result);
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchProviderException ex) {
                ex.printStackTrace();
            }
            catch (InvalidKeyException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return result;
        }
        return null;
    }

    public static ASN1Set getExtensionReqSet(String subKeyId, String[] sanArray) {
        X509ExtensionsGenerator generator = new X509ExtensionsGenerator();
        generator.addExtension(X509Extensions.SubjectKeyIdentifier, false, new SubjectKeyIdentifier(Hex.decode(subKeyId)).getDEREncoded());
        if (sanArray != null) {
            ASN1EncodableVector sanVector = new ASN1EncodableVector();
            for (int i = 0; i < sanArray.length; ++i) {
                GeneralName generalName = new GeneralName(2, sanArray[i]);
                sanVector.add(generalName);
            }
            DERSequence san = new DERSequence(sanVector);
            GeneralNames generalNames = new GeneralNames(san);
            generator.addExtension(X509Extensions.SubjectAlternativeName, false, generalNames);
        }
        DERSet exReqSet = new DERSet(new X509Attribute("1.2.840.113549.1.9.14", generator.generate()));
        return exReqSet;
    }

    public static String getKeyId2(String certRequest) throws IOException {
        ASN1Sequence seq;
        PKCS10CertificationRequest pkcscr;
        AttributeTable attributes;
        int p;
        StringBuilder sb = new StringBuilder(certRequest);
        if (sb.indexOf("-----BEGIN NEW CERTIFICATE REQUEST-----") == 0) {
            sb.delete(0, 39);
        }
        if ((p = sb.indexOf("-----END NEW CERTIFICATE REQUEST-----")) != -1) {
            sb.delete(p, sb.length());
        }
        if ((attributes = new AttributeTable((pkcscr = new PKCS10CertificationRequest(seq = (ASN1Sequence)ASN1Object.fromByteArray(Base64.decode(certRequest = sb.toString().replace("\n", "").trim())))).getCertificationRequestInfo().getAttributes())) == null) {
            System.err.println("no attributes in the request");
            return null;
        }
        Attribute attribute = attributes.get(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
        if (attribute == null) {
            System.err.println("no extensions in the request");
            return null;
        }
        ASN1Set values = attribute.getAttrValues();
        X509Extensions exts = X509Extensions.getInstance(values.getObjectAt(0));
        X509Extension ext = exts.getExtension(new DERObjectIdentifier("2.5.29.14"));
        if (ext == null) {
            System.err.println("No key identifier found");
            return null;
        }
        return Hex.encodeStr(ext.getValue().getOctets()).substring(4);
    }

    public static String getKeyId(String certRequest) {
        if (certRequest != null && !certRequest.isEmpty()) {
            String result = null;
            ASN1Sequence seq = null;
            try {
                int p;
                StringBuilder sb = new StringBuilder(certRequest);
                if (sb.indexOf("-----BEGIN NEW CERTIFICATE REQUEST-----") == 0) {
                    sb.delete(0, 39);
                }
                if ((p = sb.indexOf("-----END NEW CERTIFICATE REQUEST-----")) != -1) {
                    sb.delete(p, sb.length());
                }
                certRequest = sb.toString().replace("\n", "").trim();
                seq = (ASN1Sequence)ASN1Object.fromByteArray(Base64.decode(certRequest));
                PKCS10CertificationRequest pkcscr = new PKCS10CertificationRequest(seq);
                CertificationRequestInfo info = pkcscr.getCertificationRequestInfo();
                ASN1Set aSN1Set = info.getAttributes();
                DERSequence dERSequence1 = (DERSequence)aSN1Set.getObjectAt(0);
                DERSet dERSet1 = (DERSet)dERSequence1.getObjectAt(1);
                DERSequence dERSequence2 = (DERSequence)dERSet1.getObjectAt(0);
                DERSequence dERSequence3 = (DERSequence)dERSequence2.getObjectAt(0);
                DEROctetString octetString = (DEROctetString)dERSequence3.getObjectAt(1);
                result = Hex.encodeStr(octetString.getOctets()).substring(4);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return result;
        }
        return null;
    }
}

