/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.util.encoders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kz.gov.pki.kalkan.util.encoders.Encoder;
import kz.gov.pki.kalkan.util.encoders.HexEncoder;

public class Hex {
    private static final Encoder encoder = new HexEncoder();

    public static byte[] encode(byte[] data) {
        return Hex.encode(data, 0, data.length);
    }

    public static String encodeStr(byte[] aInput) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int idx = 0; idx < aInput.length; ++idx) {
            byte b = aInput[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString();
    }

    public static byte[] encode(byte[] data, int off, int length) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.encode(data, off, length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception encoding Hex string: " + e);
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return encoder.encode(data, 0, data.length, out);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        return encoder.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception decoding Hex string: " + e);
        }
        return bOut.toByteArray();
    }

    public static byte[] decode(String data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception decoding Hex string: " + e);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return encoder.decode(data, out);
    }
}

